/*
 * Decompiled with CFR 0.152.
 */
package plug.utils.ui.graph.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import plug.utils.function.TriConsumer;

public class PloegTreeLayout<T> {
    double defaultWidth = 5.0;
    double defaultHeight = 5.0;
    public double defaultLevelSeparation = 20.0;
    public IFanoutGetter<T> fanoutGetter;
    public Function<T, Double> widthGetter;
    public Function<T, Double> heightGetter;
    public TriConsumer<T, Double, Double> positionSetter;
    Map<T, LayoutData<T>> layoutDataMap = new IdentityHashMap<T, LayoutData<T>>();
    T virtualRoot;
    Collection<T> roots;

    public void layout(List<T> initialVertices, T virtualRoot) {
        this.virtualRoot = virtualRoot;
        this.roots = initialVertices;
        this.layout(virtualRoot);
    }

    public void layout(T root) {
        this.firstWalk(root, 0.0);
        this.secondWalk(root, 0.0);
    }

    void firstWalk(T node, double yPosition) {
        this.ensureLayoutData(node, yPosition);
        List<T> children = this.getChildren(node);
        int numberOfChildren = children.size();
        if (numberOfChildren == 0) {
            this.setExtremes(node);
            return;
        }
        T leftmostChild = children.get(0);
        double childrenY = yPosition + this.getHeight(node) + this.defaultLevelSeparation;
        this.firstWalk(leftmostChild, childrenY);
        IYL ih = PloegTreeLayout.updateIYL(this.bottom(this.getExtremeLeft(leftmostChild)), 0, null);
        for (int i = 1; i < numberOfChildren; ++i) {
            T ithChild = children.get(i);
            this.firstWalk(ithChild, childrenY);
            double minY = this.bottom(this.getExtremeRight(ithChild));
            this.seperate(node, i, ih);
            ih = PloegTreeLayout.updateIYL(minY, i, ih);
        }
        this.positionRoot(node);
        this.setExtremes(node);
    }

    void ensureLayoutData(T node, double yPosition) {
        if (!this.layoutDataMap.containsKey(node)) {
            LayoutData data = new LayoutData();
            this.layoutDataMap.put(node, data);
            data.y = yPosition;
        }
    }

    public void setDefaultWidth(double defaultWidth) {
        this.defaultWidth = defaultWidth;
    }

    public void setDefaultHeight(double defaultHeight) {
        this.defaultHeight = defaultHeight;
    }

    T getExtremeLeft(T node) {
        return this.layoutDataMap.get(node).extremeLeft;
    }

    T getExtremeRight(T node) {
        return this.layoutDataMap.get(node).extremeRight;
    }

    T getLeftThread(T node) {
        return this.layoutDataMap.get(node).leftThread;
    }

    T getRightThread(T node) {
        return this.layoutDataMap.get(node).rightThread;
    }

    double getPrelim(T node) {
        return this.layoutDataMap.get(node).prelim;
    }

    void setPrelim(T node, double prelim) {
        this.layoutDataMap.get(node).prelim = prelim;
    }

    double getMod(T node) {
        return this.layoutDataMap.get(node).mod;
    }

    double getMsel(T node) {
        return this.layoutDataMap.get(node).msel;
    }

    double getMser(T node) {
        return this.layoutDataMap.get(node).mser;
    }

    double getWidth(T node) {
        if (node == this.virtualRoot) {
            return 0.0;
        }
        if (this.widthGetter == null) {
            return this.defaultWidth;
        }
        Double width = this.widthGetter.apply(node);
        return width == null ? this.defaultWidth : width;
    }

    double getHeight(T node) {
        if (node == this.virtualRoot) {
            return 0.0;
        }
        if (this.heightGetter == null) {
            return this.defaultHeight;
        }
        Double height = this.heightGetter.apply(node);
        return height == null ? this.defaultHeight : height;
    }

    double getY(T node) {
        return this.layoutDataMap.get(node).y;
    }

    List<T> getChildren(T node) {
        if (node == this.virtualRoot) {
            return this.roots == null ? Collections.emptyList() : new ArrayList<T>(this.roots);
        }
        List<T> children = this.fanoutGetter.get(node);
        return children == null ? Collections.emptyList() : children;
    }

    void updatePosition(T node, double x, double y) {
        if (node == this.virtualRoot) {
            return;
        }
        this.positionSetter.accept(node, (Object)x, (Object)y);
    }

    double bottom(T node) {
        return this.getY(node) + this.getHeight(node);
    }

    void positionRoot(T node) {
        List<T> children = this.getChildren(node);
        T leftmostChild = children.get(0);
        T rightmostChild = children.get(children.size() - 1);
        double prelim = (this.getPrelim(leftmostChild) + this.getMod(leftmostChild) + this.getPrelim(rightmostChild) + this.getMod(rightmostChild) + this.getWidth(rightmostChild)) / 2.0 - this.getWidth(node) / 2.0;
        this.setPrelim(node, prelim);
    }

    void setExtremes(T node) {
        List<T> children = this.getChildren(node);
        LayoutData<T> data = this.layoutDataMap.get(node);
        if (children.size() == 0) {
            data.extremeLeft = node;
            data.extremeRight = node;
            data.mser = 0.0;
            data.msel = 0.0;
            return;
        }
        T leftmostChild = children.get(0);
        T rightmostChild = children.get(children.size() - 1);
        data.extremeLeft = this.getExtremeLeft(leftmostChild);
        data.msel = this.getMsel(leftmostChild);
        data.extremeRight = this.getExtremeRight(rightmostChild);
        data.mser = this.getMser(rightmostChild);
    }

    void seperate(T node, int i, IYL ih) {
        List<T> children = this.getChildren(node);
        T sr = children.get(i - 1);
        double mssr = this.getMod(sr);
        T cl = children.get(i);
        double mscl = this.getMod(cl);
        while (sr != null && cl != null) {
            double cy;
            double sy;
            double dist;
            if (this.bottom(sr) > ih.lowY) {
                ih = ih.nxt;
            }
            if ((dist = mssr + this.getPrelim(sr) + this.getWidth(sr) - (mscl + this.getPrelim(cl))) > 0.0) {
                mscl += dist;
                this.moveSubtree(node, i, ih.index, dist);
            }
            if ((sy = this.bottom(sr)) <= (cy = this.bottom(cl)) && (sr = this.nextRightContour(sr)) != null) {
                mssr += this.getMod(sr);
            }
            if (!(sy >= cy) || (cl = this.nextLeftContour(cl)) == null) continue;
            mscl += this.getMod(cl);
        }
        if (sr == null && cl != null) {
            this.setLeftThread(node, i, cl, mscl);
        } else if (sr != null && cl == null) {
            this.setRightThread(node, i, sr, mssr);
        }
    }

    void moveSubtree(T node, int i, int si, double dist) {
        List<T> children = this.getChildren(node);
        LayoutData<T> data = this.layoutDataMap.get(children.get(i));
        data.mod += dist;
        data.msel += dist;
        data.mser += dist;
        this.distributeExtra(node, i, si, dist);
    }

    T nextLeftContour(T node) {
        List<T> children = this.getChildren(node);
        return children.size() == 0 ? this.getLeftThread(node) : children.get(0);
    }

    T nextRightContour(T node) {
        List<T> children = this.getChildren(node);
        return children.size() == 0 ? this.getRightThread(node) : children.get(children.size() - 1);
    }

    void distributeExtra(T node, int i, int si, double dist) {
        if (si != i - 1) {
            List<T> children = this.getChildren(node);
            double nr = i - si;
            LayoutData<T> si1Data = this.layoutDataMap.get(children.get(si + 1));
            si1Data.shift += dist / nr;
            LayoutData<T> ithData = this.layoutDataMap.get(children.get(i));
            ithData.shift -= dist / nr;
            ithData.change -= dist - dist / nr;
        }
    }

    void setLeftThread(T node, int i, T cl, double modsumcl) {
        List<T> children = this.getChildren(node);
        LayoutData<T> leftmostData = this.layoutDataMap.get(children.get(0));
        LayoutData<T> ithData = this.layoutDataMap.get(children.get(i));
        LayoutData<T> clData = this.layoutDataMap.get(cl);
        LayoutData<T> liData = this.layoutDataMap.get(leftmostData.extremeLeft);
        liData.leftThread = cl;
        double diff = modsumcl - clData.mod - leftmostData.msel;
        liData.mod += diff;
        liData.prelim -= diff;
        leftmostData.extremeLeft = ithData.extremeLeft;
        leftmostData.msel = ithData.msel;
    }

    void setRightThread(T node, int i, T sr, double modsumsr) {
        List<T> children = this.getChildren(node);
        LayoutData<T> beforeIData = this.layoutDataMap.get(children.get(i - 1));
        LayoutData<T> ithData = this.layoutDataMap.get(children.get(i));
        LayoutData<T> srData = this.layoutDataMap.get(sr);
        LayoutData<T> riData = this.layoutDataMap.get(ithData.extremeRight);
        riData.rightThread = sr;
        double diff = modsumsr - srData.mod - ithData.mser;
        riData.mod += diff;
        riData.prelim -= diff;
        ithData.extremeRight = beforeIData.extremeRight;
        ithData.mser = beforeIData.mser;
    }

    void secondWalk(T node, double modsum) {
        List<T> children = this.getChildren(node);
        LayoutData<T> nodeData = this.layoutDataMap.get(node);
        nodeData.x = nodeData.prelim + (modsum += nodeData.mod);
        this.updatePosition(node, nodeData.x, nodeData.y);
        this.addChildSpacing(node);
        for (int i = 0; i < children.size(); ++i) {
            this.secondWalk(children.get(i), modsum);
        }
    }

    void addChildSpacing(T node) {
        List<T> children = this.getChildren(node);
        double d = 0.0;
        double modsumdelta = 0.0;
        for (int i = 0; i < children.size(); ++i) {
            LayoutData<T> ithData = this.layoutDataMap.get(children.get(i));
            ithData.mod += (modsumdelta += (d += ithData.shift) + ithData.change);
        }
    }

    static IYL updateIYL(double minY, int i, IYL ih) {
        while (ih != null && minY >= ih.lowY) {
            ih = ih.nxt;
        }
        return new IYL(minY, i, ih);
    }

    static class IYL {
        double lowY;
        int index;
        IYL nxt;

        public IYL(double lowY, int index, IYL nxt) {
            this.lowY = lowY;
            this.index = index;
            this.nxt = nxt;
        }
    }

    private class LayoutData<T> {
        double x;
        double y;
        double prelim;
        double mod;
        double shift;
        double change;
        T leftThread;
        T rightThread;
        T extremeLeft;
        T extremeRight;
        double msel;
        double mser;

        private LayoutData() {
        }
    }

    @FunctionalInterface
    public static interface IFanoutGetter<T> {
        public List<T> get(T var1);
    }
}

