/*
 * Decompiled with CFR 0.152.
 */
package properties.PropositionalLogic.interpreter;

import properties.PropositionalLogic.PropositionalLogicModel.Atom;
import properties.PropositionalLogic.PropositionalLogicModel.DeclarationBlock;
import properties.PropositionalLogic.PropositionalLogicModel.Expression;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionDeclaration;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionReference;
import properties.PropositionalLogic.PropositionalLogicModel.False;
import properties.PropositionalLogic.PropositionalLogicModel.LetExpression;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalConjunction;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalDisjunction;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalEquivalence;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalImplication;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalNegation;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalXOR;
import properties.PropositionalLogic.PropositionalLogicModel.True;
import properties.PropositionalLogic.PropositionalLogicModel.util.PropositionalLogicModelSwitch;
import properties.PropositionalLogic.interpreter.AtomEvaluatorDispatcher;
import properties.PropositionalLogic.interpreter.IAtomEvaluator;

public class EvaluatorSpaghetti
extends PropositionalLogicModelSwitch<Boolean> {
    AtomEvaluatorDispatcher atomEvaluator = new AtomEvaluatorDispatcher();

    public void setDefaultEvaluator(IAtomEvaluator evaluator) {
        this.atomEvaluator.setDefaultEvaluator(evaluator);
    }

    public void addAtomEvaluator(String language, IAtomEvaluator evaluator) {
        this.atomEvaluator.addEvaluator(language, evaluator);
    }

    @Override
    public Boolean caseAtom(Atom object) {
        return this.atomEvaluator.evaluate(object);
    }

    @Override
    public Boolean caseTrue(True object) {
        return true;
    }

    @Override
    public Boolean caseFalse(False object) {
        return false;
    }

    @Override
    public Boolean caseExpressionReference(ExpressionReference object) {
        return (Boolean)this.doSwitch(object.getExp());
    }

    @Override
    public Boolean caseLogicalNegation(LogicalNegation object) {
        return (Boolean)this.doSwitch(object.getOperand()) == false;
    }

    @Override
    public Boolean caseLogicalConjunction(LogicalConjunction object) {
        Boolean lhs = (Boolean)this.doSwitch(object.getLhs());
        Boolean rhs = (Boolean)this.doSwitch(object.getRhs());
        return lhs != false && rhs != false;
    }

    @Override
    public Boolean caseLogicalDisjunction(LogicalDisjunction object) {
        Boolean lhs = (Boolean)this.doSwitch(object.getLhs());
        Boolean rhs = (Boolean)this.doSwitch(object.getRhs());
        return lhs != false || rhs != false;
    }

    @Override
    public Boolean caseLogicalXOR(LogicalXOR object) {
        Boolean lhs = (Boolean)this.doSwitch(object.getLhs());
        Boolean rhs = (Boolean)this.doSwitch(object.getRhs());
        return lhs ^ rhs;
    }

    @Override
    public Boolean caseLogicalImplication(LogicalImplication object) {
        Boolean lhs = (Boolean)this.doSwitch(object.getLhs());
        Boolean rhs = (Boolean)this.doSwitch(object.getRhs());
        return lhs == false || rhs != false;
    }

    @Override
    public Boolean caseLogicalEquivalence(LogicalEquivalence object) {
        Boolean lhs = (Boolean)this.doSwitch(object.getLhs());
        Boolean rhs = (Boolean)this.doSwitch(object.getRhs());
        return !(lhs ^ rhs);
    }

    @Override
    public Boolean caseExpressionDeclaration(ExpressionDeclaration object) {
        return (Boolean)this.doSwitch(object.getExpression());
    }

    @Override
    public Boolean caseLetExpression(LetExpression object) {
        return (Boolean)this.doSwitch(object.getExpression());
    }

    @Override
    public Boolean caseDeclarationBlock(DeclarationBlock object) {
        throw new RuntimeException("This evaluator can only evaluate expressions");
    }

    public boolean evaluate(Expression exp) {
        return (Boolean)this.doSwitch(exp);
    }
}

