/*
 * Decompiled with CFR 0.152.
 */
package properties.PropositionalLogic.transformations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import properties.PropositionalLogic.PropositionalLogicModel.Atom;
import properties.PropositionalLogic.PropositionalLogicModel.BinaryExpression;
import properties.PropositionalLogic.PropositionalLogicModel.Declaration;
import properties.PropositionalLogic.PropositionalLogicModel.DeclarationBlock;
import properties.PropositionalLogic.PropositionalLogicModel.Expression;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionDeclaration;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionReference;
import properties.PropositionalLogic.PropositionalLogicModel.False;
import properties.PropositionalLogic.PropositionalLogicModel.LetExpression;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalNegation;
import properties.PropositionalLogic.PropositionalLogicModel.True;
import properties.PropositionalLogic.PropositionalLogicModel.UnaryExpression;
import properties.PropositionalLogic.PropositionalLogicModel.util.PropositionalLogicModelSwitch;

public class AtomExtractor {
    public List<Atom> getAtoms(Declaration declaration, Set<EObject> known) {
        Extractor extractor = new Extractor(known);
        extractor.doSwitch(declaration);
        return extractor.atoms;
    }

    public List<Atom> getAtoms(Expression expression, Set<EObject> known) {
        Extractor extractor = new Extractor(known);
        extractor.doSwitch(expression);
        return extractor.atoms;
    }

    class Extractor
    extends PropositionalLogicModelSwitch<Boolean> {
        Set<EObject> known;
        List<Atom> atoms = new ArrayList<Atom>();

        public Extractor(Set<EObject> known) {
            this.known = known;
            if (this.known == null) {
                this.known = Collections.newSetFromMap(new IdentityHashMap());
            }
        }

        @Override
        public Boolean caseAtom(Atom object) {
            if (this.known.contains(object)) {
                return true;
            }
            this.atoms.add(object);
            this.known.add(object);
            return true;
        }

        @Override
        public Boolean caseLogicalNegation(LogicalNegation object) {
            if (this.known.contains(object)) {
                return true;
            }
            this.doSwitch(object.getOperand());
            this.known.add(object);
            return true;
        }

        @Override
        public Boolean caseUnaryExpression(UnaryExpression object) {
            if (this.known.contains(object)) {
                return true;
            }
            this.known.add(object);
            return (Boolean)this.doSwitch(object.getOperand());
        }

        @Override
        public Boolean caseBinaryExpression(BinaryExpression object) {
            if (this.known.contains(object)) {
                return true;
            }
            this.doSwitch(object.getLhs());
            this.doSwitch(object.getRhs());
            this.known.add(object);
            return true;
        }

        @Override
        public Boolean caseExpressionReference(ExpressionReference object) {
            if (this.known.contains(object)) {
                return true;
            }
            this.doSwitch(object.getExp());
            this.known.add(object);
            return true;
        }

        @Override
        public Boolean caseExpressionDeclaration(ExpressionDeclaration object) {
            if (this.known.contains(object)) {
                return true;
            }
            this.doSwitch(object.getExpression());
            this.known.add(object);
            return true;
        }

        @Override
        public Boolean caseFalse(False object) {
            return true;
        }

        @Override
        public Boolean caseTrue(True object) {
            return true;
        }

        @Override
        public Boolean caseLetExpression(LetExpression object) {
            if (this.known.contains(object)) {
                return true;
            }
            for (Declaration decl : object.getDeclarations()) {
                this.doSwitch(decl);
            }
            this.doSwitch(object.getExpression());
            this.known.add(object);
            return true;
        }

        @Override
        public Boolean caseDeclarationBlock(DeclarationBlock object) {
            if (this.known.contains(object)) {
                return true;
            }
            for (Declaration decl : object.getDeclarations()) {
                this.doSwitch(decl);
            }
            this.known.add(object);
            return true;
        }
    }
}

