/*
 * Decompiled with CFR 0.152.
 */
package plug.utils.exec;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ProcessRunner {
    private final PrintWriter out;
    private final PrintWriter err;
    private Path workingPath;
    private boolean verbose = true;
    private String[] env = null;
    private long processStartDate;
    private Thread pumperOut;
    private Thread pumperErr;
    private Thread pumperIn;
    private Process currentProcess;

    public ProcessRunner(PrintWriter out, PrintWriter err) {
        this.out = out;
        this.err = err;
        this.workingPath = Paths.get(System.getProperty("user.dir"), new String[0]);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Path getWorkingPath() {
        return this.workingPath;
    }

    public void setWorkingPath(Path workingPath) {
        this.workingPath = workingPath;
    }

    public String[] getEnv() {
        return this.env;
    }

    public void setEnv(String[] env) {
        this.env = env;
    }

    public void println(String message) {
        this.out.println(message);
    }

    public void startProcess(String[] command, InputStream inContentsStream) {
        StringBuilder commandToPrint = new StringBuilder();
        commandToPrint.append("[");
        for (String arg : command) {
            if (commandToPrint.length() > 1) {
                commandToPrint.append(" ");
            }
            commandToPrint.append(arg);
        }
        commandToPrint.append("]");
        this.out.println("Exec: " + commandToPrint);
        this.currentProcess = null;
        StringBuilder outBuffer = new StringBuilder();
        try {
            this.processStartDate = System.currentTimeMillis();
            this.currentProcess = Runtime.getRuntime().exec(command, this.env, this.getWorkingPath().toFile());
            BufferedReader outReader = new BufferedReader(new InputStreamReader(this.currentProcess.getInputStream()));
            BufferedReader errReader = new BufferedReader(new InputStreamReader(this.currentProcess.getErrorStream()));
            this.pumperOut = new Thread(() -> {
                try {
                    String line = outReader.readLine();
                    while (line != null) {
                        outBuffer.append(line);
                        outBuffer.append("\n");
                        if (this.verbose) {
                            this.out.println(line);
                        }
                        line = outReader.readLine();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.out.flush();
            }, "StdOut Pumper");
            this.pumperOut.start();
            this.pumperErr = new Thread(() -> {
                try {
                    String line = errReader.readLine();
                    while (line != null) {
                        this.err.println(line);
                        line = errReader.readLine();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.err.flush();
            }, "StdErr Pumper");
            this.pumperErr.start();
            this.pumperIn = null;
            if (inContentsStream != null) {
                BufferedInputStream bufferedInContentsStream = new BufferedInputStream(inContentsStream);
                BufferedOutputStream bufferedInStream = new BufferedOutputStream(this.currentProcess.getOutputStream());
                this.pumperIn = new Thread(() -> {
                    try {
                        byte[] buffer = new byte[1024];
                        int read = 0;
                        while (read >= 0) {
                            bufferedInStream.write(buffer, 0, read);
                            read = bufferedInContentsStream.read(buffer);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        try {
                            bufferedInContentsStream.close();
                            bufferedInStream.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }, "StdIn Pumper");
                this.pumperIn.start();
            }
        }
        catch (Exception e) {
            this.out.println(outBuffer.toString());
        }
    }

    public boolean waitForProcess() {
        try {
            if (this.pumperIn != null) {
                this.pumperIn.join();
            }
            this.pumperOut.join();
            this.currentProcess.waitFor();
            this.pumperErr.join();
        }
        catch (InterruptedException e) {
            this.kill();
            return false;
        }
        long processEndDate = System.currentTimeMillis();
        double duration = (double)(processEndDate - this.processStartDate) / 1000.0;
        int status = this.currentProcess.exitValue();
        this.out.print("Process last " + duration + "s and exit with " + status + ".\n");
        this.out.flush();
        return status != 0;
    }

    public void kill() {
        if (this.currentProcess != null) {
            this.currentProcess.destroy();
            this.currentProcess = null;
        }
    }
}

