/*
 * Decompiled with CFR 0.152.
 */
package plug.utils.graph.algorithms;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import plug.utils.graph.IGraph;

public class DijkstraShortestPath<N, E> {
    public List<N> getShortestPath(IGraph<N, E> graph, N source, N target) {
        return this.getShortestPath(graph, (Collection<N>)Collections.singletonList(source), target);
    }

    public List<N> getShortestPath(IGraph<N, E> graph, Collection<N> sourceNodes, N target) {
        if (target == null) {
            return Collections.emptyList();
        }
        if (graph == null || sourceNodes == null || sourceNodes.isEmpty()) {
            return Collections.singletonList(target);
        }
        HashMap predecessors = new HashMap();
        HashMap<Object, Integer> distances = new HashMap<Object, Integer>();
        HashSet visited = new HashSet();
        PriorityQueue<NodeCost> candidates = new PriorityQueue<NodeCost>(10);
        for (Object source : sourceNodes) {
            distances.put(source, 0);
            candidates.add(new NodeCost(source, 0));
        }
        NodeCost current = null;
        while (!candidates.isEmpty()) {
            current = (NodeCost)candidates.poll();
            if (current.node == target) break;
            visited.add(current.node);
            for (Object next : graph.fanout(current.node)) {
                if (visited.contains(next)) continue;
                int distance = distances.getOrDefault(current.node, Integer.MAX_VALUE);
                if (distances.containsKey(next) && (Integer)distances.get(next) <= ++distance) continue;
                distances.put(next, distance);
                predecessors.put(next, current.node);
                candidates.add(new NodeCost(next, distance));
            }
        }
        if (current == null || current.node != target) {
            return Collections.singletonList(target);
        }
        LinkedList<Object> solution = new LinkedList<Object>();
        Object currentNode = target;
        solution.addFirst(currentNode);
        while (predecessors.containsKey(currentNode)) {
            Object parentNode = predecessors.get(currentNode);
            solution.addFirst(parentNode);
            currentNode = parentNode;
        }
        return solution;
    }

    class NodeCost
    implements Comparable<NodeCost> {
        N node;
        int cost;

        NodeCost(N node, int cost) {
            this.node = node;
            this.cost = cost;
        }

        @Override
        public int compareTo(NodeCost o) {
            if (this.cost < o.cost) {
                return -1;
            }
            if (this.cost == o.cost) {
                return 0;
            }
            return 1;
        }
    }
}

