/*
 * Decompiled with CFR 0.152.
 */
package plug.utils.ist.interval;

import plug.utils.ist.interval.Constraint;
import plug.utils.ist.interval.ExclusiveConstraint;
import plug.utils.ist.interval.InclusiveConstraint;

public class Interval {
    public static Interval EMPTY = new Interval(new ExclusiveConstraint(0), new ExclusiveConstraint(0));
    Constraint leftBound;
    Constraint rightBound;

    public Interval(Constraint leftBound, Constraint rightBound) {
        if (leftBound.gt(rightBound)) {
            leftBound = new ExclusiveConstraint(0);
            rightBound = new ExclusiveConstraint(0);
        }
        this.leftBound = leftBound;
        this.rightBound = rightBound;
    }

    public Interval singleton(int bound) {
        return new Interval(new InclusiveConstraint(bound), new InclusiveConstraint(bound));
    }

    public boolean isEmpty() {
        if (this.isUnbounded()) {
            return false;
        }
        if (this.leftBound.lt(this.rightBound)) {
            return false;
        }
        return !this.leftBound.le(this.rightBound) || this.leftBound.isInclusive() || this.rightBound.isInclusive();
    }

    public boolean gt(Interval other) {
        if (this.leftBound.gt(other.leftBound)) {
            return true;
        }
        return this.leftBound.equals(other.leftBound) && this.rightBound.gt(other.rightBound);
    }

    public boolean ge(Interval other) {
        if (this.leftBound.ge(other.leftBound)) {
            return true;
        }
        return this.leftBound.equals(other.leftBound) && this.rightBound.ge(other.rightBound);
    }

    public boolean lt(Interval other) {
        if (this.leftBound.lt(other.leftBound)) {
            return true;
        }
        return this.leftBound.equals(other.leftBound) && this.rightBound.lt(this.rightBound);
    }

    public boolean le(Interval other) {
        if (this.leftBound.le(other.leftBound)) {
            return true;
        }
        return this.leftBound.equals(other.leftBound) && this.rightBound.le(this.rightBound);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Interval)) {
            return false;
        }
        Interval other = (Interval)obj;
        return this == obj || this.leftBound.equals(other.leftBound) && this.rightBound.equals(other.rightBound);
    }

    public boolean isUnbounded() {
        return this.isLeftUnbounded() || this.isRightUnbounded();
    }

    public boolean isRightUnbounded() {
        return !this.rightBound.isBounded();
    }

    public boolean isLeftUnbounded() {
        return !this.leftBound.isBounded();
    }

    public Interval assign(Interval value) {
        this.leftBound = value.leftBound;
        this.rightBound = value.rightBound;
        return this;
    }

    public Interval assign(Constraint leftBound, Constraint rightBound) {
        this.leftBound = leftBound;
        this.rightBound = rightBound;
        return this;
    }

    public boolean includes(Interval other) {
        return this.leftBound.le(other.leftBound) && this.rightBound.ge(other.rightBound);
    }

    public boolean intersects(Interval other) {
        if (this.isEmpty() || other.isEmpty()) {
            return false;
        }
        return !this.rightBound.lt(other.leftBound) && !other.rightBound.lt(this.leftBound);
    }

    public Interval intersection(Interval other) {
        if (this.isEmpty() || other.isEmpty()) {
            return EMPTY;
        }
        if (this.rightBound.lt(other.leftBound) || other.rightBound.lt(this.leftBound)) {
            return EMPTY;
        }
        return new Interval(this.leftBound.max(other.leftBound), this.rightBound.min(other.rightBound));
    }

    public Interval union(Interval interval) {
        if (this.includes(interval)) {
            return this;
        }
        if (interval.includes(this)) {
            return interval;
        }
        return new Interval(this.leftBound.min(interval.leftBound), this.rightBound.max(interval.rightBound));
    }

    public Interval add(int value) {
        this.leftBound.add(value);
        this.rightBound.add(value);
        return this;
    }

    public Interval add(Interval interval) {
        this.leftBound.add(interval.leftBound);
        this.rightBound.add(interval.rightBound);
        return this;
    }

    public Interval subtract(int value) {
        this.leftBound.subtract(value);
        this.rightBound.subtract(value);
        return this;
    }

    public Interval subtract(Interval interval) {
        this.leftBound.subtract(interval.leftBound);
        this.rightBound.subtract(interval.rightBound);
        return this;
    }

    public Interval copy() {
        return new Interval(this.leftBound, this.rightBound);
    }
}

