/*
 * Decompiled with CFR 0.152.
 */
package plug.core;

import java.util.HashMap;
import java.util.Map;
import plug.core.ILanguageLoader;
import plug.core.IRuntimeView;
import plug.core.ITransitionRelation;
import plug.core.execution.ControllerProviderFunction;
import plug.core.view.DefaultRuntimeView;
import plug.explorer.BFSExplorer;
import plug.explorer.DFSExplorer;
import plug.verifiers.deadlock.DeadlockVerifier;

public interface ILanguagePlugin<T extends ITransitionRelation> {
    public String getName();

    public String[] getExtensions();

    public ILanguageLoader<T> getLoader();

    default public IRuntimeView getRuntimeView(T runtime) {
        return new DefaultRuntimeView(runtime);
    }

    default public Map<String, ControllerProviderFunction> executions() {
        return ILanguagePlugin.defaultExecutions();
    }

    public static Map<String, ControllerProviderFunction> defaultExecutions() {
        return new HashMap(){
            {
                this.put("BFS Explorer", BFSExplorer::new);
                this.put("Deadlock Verifier", DeadlockVerifier::bfs);
                this.put("DFS Explorer", DFSExplorer::new);
            }
        };
    }
}

