/*
 * Decompiled with CFR 0.152.
 */
package plug.explorer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import plug.core.IConfiguration;
import plug.core.IFiredTransition;
import plug.core.IStateSpaceManager;
import plug.core.ITransitionRelation;
import plug.events.CloseConfigurationEvent;
import plug.events.FiredEvent;
import plug.events.OpenConfigurationEvent;
import plug.explorer.AbstractExplorer;
import plug.simulation.selection.FireableTransitionsEvent;
import plug.simulation.selection.ISelectionPolicy;
import plug.simulation.selection.InteractiveSelectionPolicy;

@Deprecated
public class FancySimulator<C extends IConfiguration, A>
extends AbstractExplorer<C, A> {
    Set<C>[] toSee;
    int currentToSeeID = 0;
    Queue<C> selectedSourceConfigurations;
    public LinkedList<TraceEntry<C, A>> linearTrace;
    int currentStepID = 0;
    public Map<C, Set<C>> treeTrace;
    private ISelectionPolicy policy = new InteractiveSelectionPolicy();
    IConfigurationSelectionPolicy configurationSelectionPolicy = new MockConfigurationSelectionPolicy();

    public FancySimulator(ITransitionRelation<C, ?> runtime, IStateSpaceManager<C, A> stateSpaceManager) {
        super(runtime, stateSpaceManager);
    }

    public ISelectionPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(ISelectionPolicy policy) {
        this.policy = policy;
    }

    @Override
    public void initializeExploration() {
        super.initializeExploration();
        this.toSee = new Set[2];
        this.toSee[0] = Collections.newSetFromMap(new HashMap());
        this.toSee[1] = Collections.newSetFromMap(new HashMap());
        this.toSee[this.currentToSeeID].addAll(this.stateSpaceManager.initialConfigurations());
    }

    @Override
    public boolean atEnd() {
        return this.toSee[this.currentToSeeID].isEmpty() && this.toSee[1 - this.currentToSeeID].isEmpty() && this.selectedSourceConfigurations.isEmpty();
    }

    @Override
    public C nextConfiguration() {
        return (C)((IConfiguration)this.selectedSourceConfigurations.remove());
    }

    @Override
    public void schedule(C conf) {
        IConfiguration target = (IConfiguration)this.stateSpaceManager.get(conf);
        if (target == null) {
            target = (IConfiguration)this.stateSpaceManager.put(conf);
        }
        this.toSee[1 - this.currentToSeeID].add(target);
    }

    @Override
    public void explorationStep() {
        this.selectedSourceConfigurations.clear();
        this.selectedSourceConfigurations.addAll(this.configurationSelectionPolicy.selectConfigurations(this.toSee[this.currentToSeeID]));
        this.toSee[this.currentToSeeID].clear();
        while (!this.selectedSourceConfigurations.isEmpty()) {
            C source = this.nextConfiguration();
            this.announcer.announce(new OpenConfigurationEvent<C>(this, source));
            Collection<?> fireables = this.getFireableTransitions(source);
            this.announcer.announce(new FireableTransitionsEvent(fireables));
            this.fire(this.policy.chooseTargets(fireables), source);
            this.announcer.announce(new CloseConfigurationEvent<C>(this, source));
        }
        this.currentToSeeID = 1 - this.currentToSeeID;
        ++this.currentStepID;
    }

    private Collection<?> getFireableTransitions(C source) {
        return this.getRuntime().fireableTransitionsFrom(source);
    }

    public void fire(Collection<?> fireable, C source) {
        for (Object transition : fireable) {
            if (this.monitor.atEnd()) {
                return;
            }
            IFiredTransition<C, ?> fired = this.getRuntime().fireOneTransition(source, transition);
            this.announcer.announce(new FiredEvent(this, fired));
            this.stateSpaceManager.putTransition(fired);
            fired.getTargets().forEach(this::schedule);
        }
    }

    public Set<C> currentState() {
        return this.toSee[this.currentToSeeID];
    }

    public void addState(C newState) {
        this.toSee[1 - this.currentToSeeID].add(newState);
    }

    @Deprecated
    protected static class MockConfigurationSelectionPolicy
    implements IConfigurationSelectionPolicy {
        protected MockConfigurationSelectionPolicy() {
        }

        @Override
        public <C> Set<C> selectConfigurations(Set<C> potentialSources) {
            return potentialSources;
        }
    }

    @Deprecated
    protected static interface IConfigurationSelectionPolicy {
        public <C> Set<C> selectConfigurations(Set<C> var1);
    }

    @Deprecated
    protected static class TraceEntry<C, A> {
        int stepID;
        Set<C> sourceConfigurations;
        Set<A> actions;
        Set<C> targetConfigurations;

        protected TraceEntry() {
        }
    }
}

