/*
 * Decompiled with CFR 0.152.
 */
package plug.explorer.buchi.nested_dfs;

import java.util.function.Supplier;
import plug.core.IBuchiConfiguration;
import plug.core.IConfiguration;
import plug.core.ITransitionRelation;
import plug.core.execution.IExecutionController;
import plug.events.ExecutionEndedEvent;
import plug.events.PropertyEvent;
import plug.explorer.buchi.DefaultExecutionController;
import plug.explorer.buchi.nested_dfs.Color;

public class BA_GaiserSchwoon_Recursive<C extends IBuchiConfiguration & IConfiguration, A>
extends DefaultExecutionController<C, A> {
    public BA_GaiserSchwoon_Recursive(ITransitionRelation<C, A> runtime) {
        super(runtime);
    }

    @Override
    public Supplier getMetadataSupplier() {
        return () -> Color.WHITE;
    }

    @Override
    public void execute() {
        for (IBuchiConfiguration initial : this.getProductAutomaton().initialConfigurationsIterable()) {
            this.recursive_dfs_blue(initial);
        }
        this.announcer.announce(new ExecutionEndedEvent((IExecutionController)this));
    }

    private void recursive_dfs_blue(C source) {
        boolean allRed = true;
        this.setColor(source, Color.CYAN);
        for (IBuchiConfiguration target : this.getProductAutomaton().getPostIterable(source)) {
            if (this.monitor.atEnd()) break;
            if (this.getColor(target) == Color.WHITE) {
                this.recursive_dfs_blue(target);
            } else if (this.getColor(target) == Color.CYAN && (source.isAccepting() || target.isAccepting())) {
                System.out.println("source = [" + source + "], target =[" + target + "]");
                this.announcer.announce(new PropertyEvent(this, false, "property", null));
            }
            if (this.getColor(target) == Color.RED) continue;
            allRed = false;
        }
        if (allRed) {
            this.setColor(source, Color.RED);
        } else if (source.isAccepting()) {
            this.recursive_dfs_red(source);
            this.setColor(source, Color.RED);
        } else {
            this.setColor(source, Color.BLUE);
        }
    }

    private void recursive_dfs_red(C source) {
        for (IBuchiConfiguration target : this.getProductAutomaton().getPostIterable(source)) {
            if (this.monitor.atEnd()) break;
            if (this.getColor(target) == Color.CYAN) {
                System.out.println("target = [" + target + "]");
                this.announcer.announce(new PropertyEvent(this, false, "property", null));
                continue;
            }
            if (this.getColor(target) != Color.BLUE) continue;
            this.setColor(target, Color.RED);
            this.recursive_dfs_red(target);
        }
    }

    private Color getColor(C configuration) {
        return (Color)((Object)((IConfiguration)configuration).getMetadata());
    }

    private void setColor(C configuration, Color color) {
        ((IConfiguration)configuration).setMetadata((Object)color);
    }
}

