/*
 * Decompiled with CFR 0.152.
 */
package plug.ui2.simulation.configuration;

import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import org.kordamp.ikonli.javafx.FontIcon;
import plug.core.IRuntimeView;
import plug.ui2.simulation.configuration.ConfigurationTreeView;
import plug.utils.ui.fx.GuiFxUtils;

public class ConfigurationTreeViewTitledPane<C, T>
extends TitledPane {
    FontIcon expandConfigurationIcon = new FontIcon("gmi-expand-more:18:#2ecc71");
    FontIcon diffConfigurationIcon = new FontIcon("gmi-developer-mode:18:#2ecc71");
    HBox configurationToolbar = new HBox(new Node[]{this.expandConfigurationIcon, this.diffConfigurationIcon});
    ConfigurationTreeView<C, T> configurationTreeView;

    public ConfigurationTreeViewTitledPane(ObjectProperty<C> inCurrentConfiguration, ObjectProperty<IRuntimeView<C, T>> inRuntimeViewProperty) {
        this.configurationTreeView = new ConfigurationTreeView<C, T>(inCurrentConfiguration, inRuntimeViewProperty, false, false);
        this.setText("Configuration");
        this.setContent((Node)this.configurationTreeView);
        this.setGraphic((Node)this.configurationToolbar);
        this.setExpanded(true);
        this.expandConfigurationIcon.setOnMouseClicked(me -> {
            this.configurationTreeView.setExpandedTree(!this.configurationTreeView.expandedTree.get());
            this.expandConfigurationIcon.setRotate((this.expandConfigurationIcon.getRotate() + 180.0) % 360.0);
        });
        StringBinding expandBinding = Bindings.createStringBinding(() -> this.configurationTreeView.expandedTree.get() ? "Collapse tree" : "Expand tree", (Observable[])new Observable[]{this.configurationTreeView.expandedTree});
        GuiFxUtils.addTooltip((StringBinding)expandBinding, (Node)this.expandConfigurationIcon);
        GuiFxUtils.addButtonEffects((Node)this.expandConfigurationIcon);
        this.diffConfigurationIcon.setOnMouseClicked(me -> this.configurationTreeView.setShowDifferencesOnly(!this.configurationTreeView.showDifferencesOnly.get()));
        StringBinding diffBinding = Bindings.createStringBinding(() -> this.configurationTreeView.showDifferencesOnly.get() ? "Show all items" : "Show only differences", (Observable[])new Observable[]{this.configurationTreeView.showDifferencesOnly});
        GuiFxUtils.addTooltip((StringBinding)diffBinding, (Node)this.diffConfigurationIcon);
        GuiFxUtils.addButtonEffects((Node)this.diffConfigurationIcon);
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, e -> {
            EventTarget target = e.getTarget();
            if (target.equals(this.expandConfigurationIcon) || target.equals(this.diffConfigurationIcon)) {
                e.consume();
            }
        });
    }

    public void addToolbarAction(String iconDescription, StringBinding text, Consumer<Event> value) {
        FontIcon icon = new FontIcon(iconDescription);
        this.configurationToolbar.getChildren().add((Object)icon);
        icon.setOnMouseClicked(value::accept);
        GuiFxUtils.addTooltip((StringBinding)text, (Node)icon);
        GuiFxUtils.addButtonEffects((Node)icon);
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, e -> {
            EventTarget target = e.getTarget();
            if (target.equals(icon)) {
                e.consume();
            }
        });
        if (this.configurationTreeView != null) {
            this.configurationTreeView.addContextMenuAction(iconDescription, text, value);
        }
    }
}

