/*
 * Decompiled with CFR 0.152.
 */
package plug.ui2.simulation.expression_watcher;

import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import properties.PropositionalLogic.PropositionalLogicModel.Expression;
import properties.PropositionalLogic.interpreter.Evaluator;
import properties.PropositionalLogic.parser.Parser;

class WatchExpression {
    public static final WatchExpression NO_EXPRESSION = new WatchExpression(null);
    String expressionText;
    Expression expression;
    BooleanProperty selectedProperty = new SimpleBooleanProperty();
    BooleanProperty isTrue = new SimpleBooleanProperty(false);

    public BooleanProperty selectedProperty() {
        return this.selectedProperty;
    }

    WatchExpression(String expressionText) {
        this.expressionText = expressionText;
        if (expressionText != null) {
            this.expression = Parser.parse((String)expressionText, e -> {
                Alert alert = new Alert(Alert.AlertType.ERROR, "The expression '" + expressionText + "' cannot be parsed.\n" + e.getLocalizedMessage(), new ButtonType[0]);
                alert.setTitle("Proposition Compilation error");
                alert.setHeaderText(null);
                alert.showAndWait();
            });
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof WatchExpression)) {
            return false;
        }
        return Objects.equals(this.expressionText, ((WatchExpression)other).expressionText);
    }

    public String toString() {
        if (this == NO_EXPRESSION) {
            return "NO_EXPRESSION_TAG";
        }
        return (this.selectedProperty.get() ? "\u25cf " : "\u25cb ") + " " + this.expressionText;
    }

    public void updateValuation(Evaluator evaluator) {
        if (this == NO_EXPRESSION) {
            return;
        }
        if (this.expression == null) {
            return;
        }
        this.isTrue.set(evaluator.evaluate(this.expression));
    }
}

