/*
 * Decompiled with CFR 0.152.
 */
package plug.ui2.simulation.fireables;

import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SetProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleSetProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Background;
import javafx.scene.layout.StackPane;
import org.kordamp.ikonli.javafx.FontIcon;
import plug.core.IFiredTransition;
import plug.core.IRuntimeView;
import plug.core.ITransitionRelation;
import plug.simulation.trace_storage.TraceEntry;
import plug.simulation.trace_storage.TraceStore;
import plug.ui2.simulation.fireables.FireableTransitionCell;
import plug.utils.ui.fx.GuiFxUtils;

public class FireableTransitionsView<C, T>
extends StackPane {
    private final ObjectProperty<ITransitionRelation<C, T>> transitionRelationProperty;
    private final ObjectProperty<IFiredTransition<C, ?>> outFiredTransition;
    protected final Random rnd = new Random();
    ObjectProperty<TraceEntry<C, Object>> currentEntry;
    protected ListProperty<T> fireableTransitions = new SimpleListProperty();
    protected final ListView<T> listView;
    ObjectProperty<TraceStore<C, Object>> traceStore;

    public FireableTransitionsView(ObjectProperty<TraceEntry<C, Object>> inCurrentEntry, ObjectProperty<ITransitionRelation<C, T>> inTransitionRelationProperty, ObjectProperty<IRuntimeView<C, T>> inRuntimeViewProperty, ObjectProperty<IFiredTransition<C, ?>> outFiredTransition, ObjectProperty<TraceStore<C, Object>> inTraceStore) {
        this.currentEntry = inCurrentEntry;
        this.transitionRelationProperty = inTransitionRelationProperty;
        this.outFiredTransition = outFiredTransition;
        this.traceStore = inTraceStore;
        this.setBackground(Background.EMPTY);
        this.fireableTransitions.bind((ObservableValue)Bindings.createObjectBinding(this::fireableTransitionsFromCallback, (Observable[])new Observable[]{this.currentEntry}));
        SimpleSetProperty alreadyFiredSet = new SimpleSetProperty();
        alreadyFiredSet.bind((ObservableValue)Bindings.createObjectBinding(this::alreadyFiredCallback, (Observable[])new Observable[]{this.currentEntry, this.fireableTransitions}));
        Button stepRandomButton = new Button("", (Node)new FontIcon("typ-arrow-shuffle:20:darkgreen"));
        stepRandomButton.setPickOnBounds(false);
        stepRandomButton.setId("fireRandom");
        stepRandomButton.setTooltip(new Tooltip("Fire Random Transition"));
        GuiFxUtils.addButtonEffects((Node)stepRandomButton);
        stepRandomButton.setOnAction(event -> {
            int numberOfFireables = this.fireableTransitions.size();
            if (numberOfFireables < 1) {
                return;
            }
            int index = this.rnd.nextInt(numberOfFireables);
            this.fireCallback(this.fireableTransitions.get(index));
        });
        this.fireableTransitions.addListener((a, o, n) -> {
            if (n == null || n.isEmpty()) {
                stepRandomButton.setDisable(true);
            } else {
                stepRandomButton.setDisable(false);
            }
        });
        this.listView = new ListView(this.fireableTransitions);
        this.listView.setCellFactory(arg_0 -> this.lambda$new$2(inRuntimeViewProperty, (SetProperty)alreadyFiredSet, arg_0));
        this.listView.setOnMouseClicked(e -> {
            if (e.getClickCount() == 2) {
                this.fireCallback(this.listView.getSelectionModel().getSelectedItem());
            }
        });
        this.getChildren().addAll((Object[])new Node[]{this.listView, stepRandomButton});
        FireableTransitionsView.setAlignment((Node)stepRandomButton, (Pos)Pos.CENTER_RIGHT);
    }

    private ObservableList<T> fireableTransitionsFromCallback() {
        ITransitionRelation transitionRelation = (ITransitionRelation)this.transitionRelationProperty.get();
        TraceEntry entry = (TraceEntry)this.currentEntry.get();
        if (entry == null) {
            return FXCollections.emptyObservableList();
        }
        Object source = entry.getConfiguration();
        if (source == null) {
            return FXCollections.emptyObservableList();
        }
        Collection fireables = transitionRelation.fireableTransitionsFrom(source);
        if (transitionRelation.hasBlockingTransitions()) {
            Iterator iterator = fireables.iterator();
            while (iterator.hasNext()) {
                Object fireable = iterator.next();
                IFiredTransition fired = transitionRelation.fireOneTransition(source, fireable);
                if (fired != null && !fired.getTargets().isEmpty()) continue;
                iterator.remove();
            }
        }
        return FXCollections.observableArrayList((Collection)fireables);
    }

    private ObservableSet<T> alreadyFiredCallback() {
        TraceEntry entry = (TraceEntry)this.currentEntry.get();
        if (entry == null) {
            return FXCollections.emptyObservableSet();
        }
        Set set = this.fireableTransitions.stream().filter(fireable -> {
            for (TraceEntry child : entry.getChildren()) {
                if (!fireable.equals(child.getAction())) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
        return FXCollections.observableSet(set);
    }

    private void fireCallback(T transition) {
        ITransitionRelation transitionRelation = (ITransitionRelation)this.transitionRelationProperty.get();
        if (this.currentEntry.get() == null || transition == null) {
            return;
        }
        this.outFiredTransition.set((Object)transitionRelation.fireOneTransition(((TraceEntry)this.currentEntry.get()).getConfiguration(), transition));
    }

    private /* synthetic */ ListCell lambda$new$2(ObjectProperty inRuntimeViewProperty, SetProperty alreadyFiredSet, ListView v) {
        return new FireableTransitionCell(this::fireCallback, inRuntimeViewProperty, (ObservableSet<Object>)alreadyFiredSet);
    }
}

