/*
 * Decompiled with CFR 0.152.
 */
package plug.language.remote.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import plug.core.IConfiguration;
import plug.core.IFiredTransition;
import plug.core.ITransitionRelation;
import plug.core.RuntimeDescription;
import plug.core.view.ConfigurationItem;
import plug.language.remote.client.IRuntimeSerializer;
import plug.utils.marshaling.Marshaller;
import plug.utils.marshaling.Unmarshaller;

public class DistantRuntime {
    protected final String address;
    protected final int port;
    protected final RuntimeDescription description;
    protected final IRuntimeSerializer serializer;
    protected ServerSocket serverSocket;
    protected Socket connectedSocket;
    protected BufferedInputStream inputStream;
    protected BufferedOutputStream outputStream;
    protected ITransitionRelation<IConfiguration, Object> runtime;

    public DistantRuntime(int port, RuntimeDescription description, IRuntimeSerializer serializer) {
        this("127.0.0.1", port, description, serializer);
    }

    public DistantRuntime(String address, int port, RuntimeDescription description, IRuntimeSerializer serializer) {
        this.address = address;
        this.port = port;
        this.description = description;
        this.serializer = serializer;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public RuntimeDescription getDescription() {
        return this.description;
    }

    public void connect() throws Exception {
        this.serverSocket = new ServerSocket(this.port);
        this.connectedSocket = this.serverSocket.accept();
        this.inputStream = new BufferedInputStream(this.connectedSocket.getInputStream());
        this.outputStream = new BufferedOutputStream(this.connectedSocket.getOutputStream());
        this.runtime = this.description.getRuntime();
    }

    private ConfigurationItem readConfigurationItem() throws IOException {
        String type = Unmarshaller.readString((InputStream)this.inputStream);
        String name = Unmarshaller.readString((InputStream)this.inputStream);
        String icon = Unmarshaller.readString((InputStream)this.inputStream);
        ArrayList<ConfigurationItem> children = new ArrayList<ConfigurationItem>();
        int childrenCount = Unmarshaller.readInt((InputStream)this.inputStream);
        for (int i = 0; i < childrenCount; ++i) {
            children.add(this.readConfigurationItem());
        }
        return new ConfigurationItem(type, name, icon, children);
    }

    private void writeConfigurationItem(ConfigurationItem item) throws IOException {
        Marshaller.writeString((String)item.getType(), (OutputStream)this.outputStream);
        Marshaller.writeString((String)item.getName(), (OutputStream)this.outputStream);
        Marshaller.writeString((String)item.getIcon(), (OutputStream)this.outputStream);
        Marshaller.writeInt((int)item.getChildren().size(), (OutputStream)this.outputStream);
        for (ConfigurationItem child : item.getChildren()) {
            this.writeConfigurationItem(child);
        }
    }

    public void sendConfigurations(Collection<IConfiguration> configurations) throws IOException {
        Marshaller.writeInt((int)configurations.size(), (OutputStream)this.outputStream);
        for (IConfiguration configuration : configurations) {
            byte[] bytes = this.serializer.serializeConfiguration(configuration);
            Marshaller.writeInt((int)bytes.length, (OutputStream)this.outputStream);
            Marshaller.write((byte[])bytes, (OutputStream)this.outputStream);
        }
    }

    public void sendTransitions(Collection<Object> transitions) throws IOException {
        Marshaller.writeInt((int)transitions.size(), (OutputStream)this.outputStream);
        for (Object transition : transitions) {
            byte[] bytes = this.serializer.serializeTransition(transition);
            Marshaller.writeInt((int)bytes.length, (OutputStream)this.outputStream);
            Marshaller.write((byte[])bytes, (OutputStream)this.outputStream);
        }
    }

    public void handleInitialConfigurations() throws IOException {
        this.sendConfigurations(this.runtime.initialConfigurations());
        this.outputStream.flush();
    }

    public void handleFireableTransitions() throws IOException {
        int configurationSize = Unmarshaller.readInt((InputStream)this.inputStream);
        byte[] buffer = Unmarshaller.readData((int)configurationSize, (InputStream)this.inputStream);
        Object configuration = this.serializer.deserializeConfiguration(buffer);
        this.sendTransitions(this.runtime.fireableTransitionsFrom(configuration));
        this.outputStream.flush();
    }

    public void handleFireTransition() throws IOException {
        int configurationSize = Unmarshaller.readInt((InputStream)this.inputStream);
        byte[] buffer = Unmarshaller.readData((int)configurationSize, (InputStream)this.inputStream);
        Object configuration = this.serializer.deserializeConfiguration(buffer);
        int transitionSize = Unmarshaller.readInt((InputStream)this.inputStream);
        byte[] transitionBuffer = Unmarshaller.readData((int)transitionSize, (InputStream)this.inputStream);
        Object transition = this.serializer.deserializeTransition(transitionBuffer);
        IFiredTransition fired = this.runtime.fireOneTransition(configuration, transition);
        this.sendConfigurations(fired.getTargets());
        byte[] payload = this.serializer.serializePayload(fired.getPayload());
        Marshaller.writeInt((int)payload.length, (OutputStream)this.outputStream);
        Marshaller.write((byte[])payload, (OutputStream)this.outputStream);
        this.outputStream.flush();
    }

    public boolean handleRequest() throws IOException {
        int status = this.inputStream.read();
        if (status == 1) {
            byte request = (byte)this.inputStream.read();
            switch (request) {
                case 1: {
                    this.handleInitialConfigurations();
                    break;
                }
                case 2: {
                    this.handleFireableTransitions();
                    break;
                }
                case 3: {
                    this.handleFireTransition();
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 6: 
                case 10: {
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        this.serverSocket.close();
    }
}

