/*
 * Decompiled with CFR 0.152.
 */
package plug.language.remote.driver;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import plug.core.IFiredTransition;
import plug.core.view.ConfigurationItem;
import plug.language.remote.driver.AbstractDriver;
import plug.language.remote.protocol.RequestKind;
import plug.language.remote.runtime.Configuration;
import plug.language.remote.runtime.FireableTransition;
import plug.statespace.transitions.FiredTransition;
import plug.utils.marshaling.Marshaller;
import plug.utils.marshaling.Unmarshaller;

public class TCPDriver
extends AbstractDriver {
    private String address;
    private int port;
    private Socket socket;
    private BufferedInputStream inputStream;
    private BufferedOutputStream outputStream;

    public TCPDriver(String address, int port) {
        this.address = address;
        this.port = port;
    }

    @Override
    public void connect() throws IOException {
        ConnectException exception = null;
        for (int i = 0; i < 10; ++i) {
            try {
                System.out.println("Connecting to " + this.address + ":" + this.port + " (attempt " + (i + 1) + ")");
                this.socket = new Socket(this.address, this.port);
                this.inputStream = new BufferedInputStream(this.socket.getInputStream());
                this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
                exception = null;
                break;
            }
            catch (ConnectException e) {
                exception = e;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void disconnect() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String readString() throws IOException {
        int size = Unmarshaller.readInt((InputStream)this.inputStream);
        return size < 0 ? null : new String(Unmarshaller.readData((int)size, (InputStream)this.inputStream), StandardCharsets.UTF_8);
    }

    @Override
    public synchronized Set<Configuration> initialConfigurations() {
        HashSet<Configuration> configurations = new HashSet<Configuration>();
        try {
            RequestKind.REQ_INITIAL_CONFIGURATIONS.writeOn(this.outputStream);
            this.outputStream.flush();
            int numConfigurations = Unmarshaller.readInt((InputStream)this.inputStream);
            for (int i = 0; i < numConfigurations; ++i) {
                int configurationSize = Unmarshaller.readInt((InputStream)this.inputStream);
                configurations.add(new Configuration(Unmarshaller.readData((int)configurationSize, (InputStream)this.inputStream)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return configurations;
    }

    @Override
    public synchronized Collection<FireableTransition> fireableTransitionsFrom(Configuration configuration) {
        ArrayList<FireableTransition> fireableTransitions = new ArrayList<FireableTransition>();
        try {
            RequestKind.REQ_FIREABLE_TRANSITIONS_FROM.writeOn(this.outputStream);
            Marshaller.writeInt((int)configuration.state.length, (OutputStream)this.outputStream);
            configuration.writeOn(this.outputStream);
            this.outputStream.flush();
            int numTransitions = Unmarshaller.readInt((InputStream)this.inputStream);
            for (int i = 0; i < numTransitions; ++i) {
                int transitionSize = Unmarshaller.readInt((InputStream)this.inputStream);
                fireableTransitions.add(new FireableTransition(Unmarshaller.readData((int)transitionSize, (InputStream)this.inputStream)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fireableTransitions;
    }

    @Override
    public synchronized IFiredTransition<Configuration, FireableTransition> fireOneTransition(Configuration source, FireableTransition toFire) {
        LinkedList<Configuration> configurations = new LinkedList<Configuration>();
        byte[] payload = new byte[]{};
        try {
            RequestKind.REQ_FIRE_TRANSITION.writeOn(this.outputStream);
            Marshaller.writeInt((int)source.state.length, (OutputStream)this.outputStream);
            source.writeOn(this.outputStream);
            Marshaller.writeInt((int)toFire.data.length, (OutputStream)this.outputStream);
            toFire.writeOn(this.outputStream);
            this.outputStream.flush();
            int numConfigurations = Unmarshaller.readInt((InputStream)this.inputStream);
            for (int i = 0; i < numConfigurations; ++i) {
                int configurationSize = Unmarshaller.readInt((InputStream)this.inputStream);
                configurations.add(new Configuration(Unmarshaller.readData((int)configurationSize, (InputStream)this.inputStream)));
            }
            int payloadSize = Unmarshaller.readInt((InputStream)this.inputStream);
            payload = Unmarshaller.readData((int)payloadSize, (InputStream)this.inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new FiredTransition((Object)source, configurations, (Object)toFire, (Object)payload);
    }

    @Override
    public synchronized int[] registerAtomicPropositions(String[] atomicPropositions) throws IOException {
        RequestKind.REQ_REGISTER_ATOMIC_PROPOSITIONS.writeOn(this.outputStream);
        ByteBuffer data = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        data.putInt(atomicPropositions.length);
        this.outputStream.write(data.array());
        for (String atomicProposition : atomicPropositions) {
            byte[] bytes = atomicProposition.getBytes(StandardCharsets.UTF_8);
            data = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
            data.putInt(bytes.length);
            this.outputStream.write(data.array());
            this.outputStream.write(bytes);
        }
        this.outputStream.flush();
        int size = Unmarshaller.readInt((InputStream)this.inputStream);
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = Unmarshaller.readInt((InputStream)this.inputStream);
        }
        return result;
    }

    @Override
    public synchronized boolean[] getAtomicPropositionValuations(Configuration configuration) {
        try {
            RequestKind.REQ_ATOMIC_PROPOSITION_VALUATIONS.writeOn(this.outputStream);
            Marshaller.writeInt((int)configuration.state.length, (OutputStream)this.outputStream);
            configuration.writeOn(this.outputStream);
            this.outputStream.flush();
            int valueCount = Unmarshaller.readInt((InputStream)this.inputStream);
            byte[] rawValues = Unmarshaller.readData((int)valueCount, (InputStream)this.inputStream);
            boolean[] values = new boolean[valueCount];
            for (int i = 0; i < valueCount; ++i) {
                values[i] = rawValues[i] > 0;
            }
            return values;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new boolean[0];
        }
    }

    @Override
    public synchronized boolean[] getAtomicPropositionValuations(Configuration source, FireableTransition fireable, Object payload, Configuration target) {
        try {
            RequestKind.REQ_EXTENDED_ATOMIC_PROPOSITION_VALUATIONS.writeOn(this.outputStream);
            Marshaller.writeInt((int)source.state.length, (OutputStream)this.outputStream);
            source.writeOn(this.outputStream);
            if (fireable == null) {
                Marshaller.writeInt((int)0, (OutputStream)this.outputStream);
            } else {
                Marshaller.writeInt((int)fireable.data.length, (OutputStream)this.outputStream);
                fireable.writeOn(this.outputStream);
            }
            if (payload == null) {
                Marshaller.writeInt((int)0, (OutputStream)this.outputStream);
            } else {
                byte[] thePayload = (byte[])payload;
                Marshaller.writeInt((int)thePayload.length, (OutputStream)this.outputStream);
                this.outputStream.write(thePayload);
            }
            Marshaller.writeInt((int)target.state.length, (OutputStream)this.outputStream);
            target.writeOn(this.outputStream);
            this.outputStream.flush();
            int valueCount = Unmarshaller.readInt((InputStream)this.inputStream);
            byte[] rawValues = Unmarshaller.readData((int)valueCount, (InputStream)this.inputStream);
            boolean[] values = new boolean[valueCount];
            for (int i = 0; i < valueCount; ++i) {
                values[i] = rawValues[i] > 0;
            }
            return values;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new boolean[0];
        }
    }

    private synchronized ConfigurationItem readConfigurationItem() throws IOException {
        String type = this.readString();
        String name = this.readString();
        String icon = this.readString();
        ArrayList<ConfigurationItem> children = new ArrayList<ConfigurationItem>();
        int childrenCount = Unmarshaller.readInt((InputStream)this.inputStream);
        for (int i = 0; i < childrenCount; ++i) {
            children.add(this.readConfigurationItem());
        }
        return new ConfigurationItem(type, name, icon, children);
    }

    @Override
    public synchronized List<ConfigurationItem> getConfigurationItems(Configuration value) {
        try {
            RequestKind.REQ_CONFIGURATION_ITEMS.writeOn(this.outputStream);
            Marshaller.writeInt((int)value.state.length, (OutputStream)this.outputStream);
            value.writeOn(this.outputStream);
            this.outputStream.flush();
            ArrayList<ConfigurationItem> items = new ArrayList<ConfigurationItem>();
            int itemsCount = Unmarshaller.readInt((InputStream)this.inputStream);
            for (int i = 0; i < itemsCount; ++i) {
                items.add(this.readConfigurationItem());
            }
            return items;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public synchronized String getFireableTransitionDescription(FireableTransition transition) {
        try {
            RequestKind.REQ_FIREABLE_TRANSITION_DESCRIPTION.writeOn(this.outputStream);
            Marshaller.writeInt((int)transition.data.length, (OutputStream)this.outputStream);
            transition.writeOn(this.outputStream);
            this.outputStream.flush();
            return this.readString();
        }
        catch (IOException e) {
            return "Transition " + Arrays.toString(transition.data);
        }
    }
}

