/*
 * Decompiled with CFR 0.152.
 */
package plug.language.buchikripke.sk_tba;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import plug.core.IConfiguration;
import plug.core.IFiredTransition;
import plug.core.IRuntimeView;
import plug.core.view.ConfigurationItem;
import plug.language.buchi.runtime.BuchiRuntimeView;
import plug.language.buchikripke.runtime.KripkeBuchiConfiguration;
import plug.language.buchikripke.runtime.KripkeBuchiProductSemantics;
import plug.language.buchikripke.sk_tba.SK_TBA_ProductSemantics;
import plug.utils.Pair;
import properties.BuchiAutomata.BuchiAutomataModel.GuardedTransition;

public class SK_TBA_RuntimeView
implements IRuntimeView<KripkeBuchiConfiguration, Pair<IFiredTransition<IConfiguration, Object>, GuardedTransition>> {
    protected final SK_TBA_ProductSemantics runtime;
    final IRuntimeView kripkeRuntimeView;
    final IRuntimeView buchiRuntimeView;

    public SK_TBA_RuntimeView(SK_TBA_ProductSemantics runtime) {
        this.runtime = runtime;
        this.kripkeRuntimeView = runtime.getKripke().getModule().getRuntimeView(runtime.getKripkeRuntime());
        this.buchiRuntimeView = new BuchiRuntimeView(runtime.getBuchiRuntime());
    }

    public SK_TBA_ProductSemantics getRuntime() {
        return this.runtime;
    }

    public List<ConfigurationItem> getConfigurationItems(KripkeBuchiConfiguration value) {
        ArrayList<ConfigurationItem> children = new ArrayList<ConfigurationItem>();
        List buchiState = this.buchiRuntimeView.getConfigurationItems((Object)value.buchiState);
        ConfigurationItem buchiProcess = new ConfigurationItem("process", "bucchi", null, buchiState);
        buchiProcess.setExpanded(true);
        children.add(buchiProcess);
        if (value.kripke != null) {
            String description = this.kripkeRuntimeView.getConfigurationDescription((Object)value.kripke);
            List kripkeChildren = this.kripkeRuntimeView.getConfigurationItems((Object)value.kripke);
            ConfigurationItem kripkeProcess = new ConfigurationItem("process", description, null, kripkeChildren);
            kripkeProcess.setExpanded(true);
            children.add(kripkeProcess);
        } else {
            children.add(new ConfigurationItem("process", "<not present>", null, null));
        }
        return children;
    }

    public String getFireableTransitionDescription(Pair<IFiredTransition<IConfiguration, Object>, GuardedTransition> transition) {
        Object action = ((IFiredTransition)transition.a).getAction();
        if (action instanceof KripkeBuchiProductSemantics.StutteringTransition) {
            return "Buchi stuttering";
        }
        if (action == null) {
            return "Buchi initial transition";
        }
        String kripkeTransitionDescription = this.kripkeRuntimeView.getFireableTransitionDescription(action);
        String buchiTransitionDescription = this.buchiRuntimeView.getFireableTransitionDescription(transition.b);
        return kripkeTransitionDescription + "\n/\\\n" + buchiTransitionDescription;
    }

    public String getActionDescription(Object action) {
        if (action instanceof Pair) {
            Pair transition = (Pair)action;
            Object childAction = ((IFiredTransition)transition.a).getAction();
            if (childAction instanceof KripkeBuchiProductSemantics.StutteringTransition) {
                return "Buchi stuttering";
            }
            if (childAction == null) {
                return "Buchi initial transition";
            }
            return this.kripkeRuntimeView.getActionDescription(childAction);
        }
        return Objects.toString(action);
    }
}

