/*
 * Decompiled with CFR 0.152.
 */
package properties.LTL.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import org.antlr.v4.runtime.tree.TerminalNode;
import properties.BuchiAutomata.BuchiAutomataModel.AcceptingState;
import properties.BuchiAutomata.BuchiAutomataModel.Automaton;
import properties.BuchiAutomata.BuchiAutomataModel.Buchi;
import properties.BuchiAutomata.BuchiAutomataModel.BuchiAutomataModelFactory;
import properties.BuchiAutomata.BuchiAutomataModel.BuchiDeclaration;
import properties.BuchiAutomata.BuchiAutomataModel.GuardedTransition;
import properties.BuchiAutomata.BuchiAutomataModel.State;
import properties.LTL.LTLModel.Eventually;
import properties.LTL.LTLModel.Globally;
import properties.LTL.LTLModel.LTLModelFactory;
import properties.LTL.LTLModel.Next;
import properties.LTL.LTLModel.StrongRelease;
import properties.LTL.LTLModel.StrongUntil;
import properties.LTL.LTLModel.WeakRelease;
import properties.LTL.LTLModel.WeakUntil;
import properties.LTL.grammar.LTLBaseListener;
import properties.LTL.grammar.LTLParser;
import properties.PropositionalLogic.PropositionalLogicModel.Atom;
import properties.PropositionalLogic.PropositionalLogicModel.Declaration;
import properties.PropositionalLogic.PropositionalLogicModel.DeclarationBlock;
import properties.PropositionalLogic.PropositionalLogicModel.Expression;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionDeclaration;
import properties.PropositionalLogic.PropositionalLogicModel.ExpressionReference;
import properties.PropositionalLogic.PropositionalLogicModel.LetExpression;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalConjunction;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalDisjunction;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalEquivalence;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalImplication;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalNegation;
import properties.PropositionalLogic.PropositionalLogicModel.LogicalXOR;
import properties.PropositionalLogic.PropositionalLogicModel.PropositionalLogicModelFactory;
import properties.PropositionalLogic.parser.TreeAnnotator;

public class ASTBuilder
extends LTLBaseListener
implements TreeAnnotator {
    public ParseTreeProperty<Object> values = new ParseTreeProperty();
    PropositionalLogicModelFactory factory = PropositionalLogicModelFactory.eINSTANCE;
    LTLModelFactory ltlFactory = LTLModelFactory.eINSTANCE;
    final BuchiAutomataModelFactory buchiFactory = BuchiAutomataModelFactory.eINSTANCE;

    public ParseTreeProperty<Object> getValues() {
        return this.values;
    }

    @Override
    public void exitLiteral(LTLParser.LiteralContext ctx) {
        this.setValue((ParseTree)ctx, ctx.TRUE() == null ? this.factory.createFalse() : this.factory.createTrue());
    }

    @Override
    public void exitAtom(LTLParser.AtomContext ctx) {
        Atom atom = this.factory.createAtom();
        String language = ctx.IDENTIFIER() != null ? ctx.IDENTIFIER().getText() : null;
        atom.setLanguage(language);
        String code = ctx.ATOMINLINE().getText();
        atom.setCode(code.substring(1, code.length() - 1));
        atom.setDelimiterString(code.substring(0, 1));
        this.setValue((ParseTree)ctx, atom);
    }

    @Override
    public void exitParenExp(LTLParser.ParenExpContext ctx) {
        this.setValue((ParseTree)ctx, this.getValue((ParseTree)ctx.formula()));
    }

    @Override
    public void exitUnaryExp(LTLParser.UnaryExpContext ctx) {
        switch (ctx.operator.getType()) {
            case 12: {
                LogicalNegation value = this.factory.createLogicalNegation();
                value.setOperatorToken(ctx.operator.getText());
                value.setOperand((Expression)this.getValue((ParseTree)ctx.formula(), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 13: {
                Next value = this.ltlFactory.createNext();
                value.setOperatorToken(ctx.operator.getText());
                value.setOperand((Expression)this.getValue((ParseTree)ctx.formula(), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 6: {
                Eventually value = this.ltlFactory.createEventually();
                value.setOperatorToken(ctx.operator.getText());
                value.setOperand((Expression)this.getValue((ParseTree)ctx.formula(), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 8: {
                Globally value = this.ltlFactory.createGlobally();
                value.setOperatorToken(ctx.operator.getText());
                value.setOperand((Expression)this.getValue((ParseTree)ctx.formula(), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
        }
    }

    @Override
    public void exitBinaryExp(LTLParser.BinaryExpContext ctx) {
        switch (ctx.operator.getType()) {
            case 3: {
                LogicalConjunction value = this.factory.createLogicalConjunction();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 4: {
                LogicalDisjunction value = this.factory.createLogicalDisjunction();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 19: {
                LogicalXOR value = this.factory.createLogicalXOR();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 9: {
                LogicalImplication value = this.factory.createLogicalImplication();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 5: {
                LogicalEquivalence value = this.factory.createLogicalEquivalence();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 14: {
                StrongUntil value = this.ltlFactory.createStrongUntil();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 15: {
                WeakUntil value = this.ltlFactory.createWeakUntil();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 16: {
                StrongRelease value = this.ltlFactory.createStrongRelease();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
            case 17: {
                WeakRelease value = this.ltlFactory.createWeakRelease();
                value.setOperatorToken(ctx.operator.getText());
                value.setLhs((Expression)this.getValue((ParseTree)ctx.formula(0), Expression.class));
                value.setRhs((Expression)this.getValue((ParseTree)ctx.formula(1), Expression.class));
                this.setValue((ParseTree)ctx, value);
                return;
            }
        }
        throw new RuntimeException("unexpected binary operator: " + ctx.operator.getText() + " (line: " + ctx.getStart().getLine() + ")\n");
    }

    @Override
    public void exitFormulaDeclaration(LTLParser.FormulaDeclarationContext ctx) {
        if (ctx.formula() != null) {
            ExpressionDeclaration value = this.factory.createExpressionDeclaration();
            value.setName(ctx.IDENTIFIER().getText());
            value.setExpression((Expression)this.getValue((ParseTree)ctx.formula(), Expression.class));
            this.setValue((ParseTree)ctx, value);
            return;
        }
        if (ctx.buchiDecl() != null) {
            BuchiDeclaration value = (BuchiDeclaration)this.getValue((ParseTree)ctx.buchiDecl(), BuchiDeclaration.class);
            value.setName(ctx.IDENTIFIER().getText());
            this.setValue((ParseTree)ctx, value);
            return;
        }
    }

    @Override
    public void exitFormulaDeclarationList(LTLParser.FormulaDeclarationListContext ctx) {
        ArrayList<Object> value = new ArrayList<Object>();
        for (LTLParser.FormulaDeclarationContext fctx : ctx.formulaDeclaration()) {
            value.add(this.getValue((ParseTree)fctx, ExpressionDeclaration.class));
        }
        this.setValue((ParseTree)ctx, value);
    }

    @Override
    public void exitLetDecl(LTLParser.LetDeclContext ctx) {
        LetExpression value = this.factory.createLetExpression();
        List declarations = (List)this.getValue((ParseTree)ctx.formulaDeclarationList(), List.class);
        value.getDeclarations().addAll((Collection)declarations);
        this.setValue((ParseTree)ctx, value);
    }

    @Override
    public void exitLetExp(LTLParser.LetExpContext ctx) {
        LetExpression value = (LetExpression)this.getValue((ParseTree)ctx.letDecl(), LetExpression.class);
        value.setExpression((Expression)this.getValue((ParseTree)ctx.formula(), Expression.class));
        this.setValue((ParseTree)ctx, value);
    }

    @Override
    public void exitBlock(LTLParser.BlockContext ctx) {
        DeclarationBlock value = this.factory.createDeclarationBlock();
        for (LTLParser.FormulaDeclarationContext fctx : ctx.formulaDeclaration()) {
            value.getDeclarations().add(this.getValue((ParseTree)fctx, Declaration.class));
        }
        this.setValue((ParseTree)ctx, value);
    }

    @Override
    public void exitAtomExp(LTLParser.AtomExpContext ctx) {
        this.setValue((ParseTree)ctx, this.getValue((ParseTree)ctx.atom()));
    }

    @Override
    public void exitLiteralExp(LTLParser.LiteralExpContext ctx) {
        this.setValue((ParseTree)ctx, this.getValue((ParseTree)ctx.literal()));
    }

    @Override
    public void exitReferenceExp(LTLParser.ReferenceExpContext ctx) {
        ExpressionReference value = this.factory.createExpressionReference();
        value.setName(ctx.IDENTIFIER().getText());
        this.setValue((ParseTree)ctx, value);
    }

    @Override
    public void exitStateDecl(LTLParser.StateDeclContext ctx) {
        HashMap<String, State> value = new HashMap<String, State>();
        for (TerminalNode idT : ctx.IDENTIFIER()) {
            State state = this.buchiFactory.createState();
            state.setName(idT.getText());
            value.put(idT.getText(), state);
        }
        this.setValue((ParseTree)ctx, value);
    }

    @Override
    public void exitInitialDecl(LTLParser.InitialDeclContext ctx) {
        ArrayList<String> value = new ArrayList<String>();
        for (TerminalNode idT : ctx.IDENTIFIER()) {
            value.add(idT.getText());
        }
        this.setValue((ParseTree)ctx, value);
    }

    @Override
    public void exitAcceptDecl(LTLParser.AcceptDeclContext ctx) {
        ArrayList<String> value = new ArrayList<String>();
        for (TerminalNode idT : ctx.IDENTIFIER()) {
            value.add(idT.getText());
        }
        this.setValue((ParseTree)ctx, value);
    }

    @Override
    public void exitTransitionDecl(LTLParser.TransitionDeclContext ctx) {
        GuardedTransition transition = this.buchiFactory.createGuardedTransition();
        State from = this.buchiFactory.createState();
        from.setName(ctx.IDENTIFIER(0).getText());
        transition.setFrom(from);
        State to = this.buchiFactory.createState();
        to.setName(ctx.IDENTIFIER(1).getText());
        transition.setTo(to);
        transition.setGuard((Expression)this.getValue((ParseTree)ctx.formula(), Expression.class));
        this.setValue((ParseTree)ctx, transition);
    }

    @Override
    public void exitAutomatonDecl(LTLParser.AutomatonDeclContext ctx) {
        Automaton automaton = this.buchiFactory.createAutomaton();
        Map states = (Map)this.getValue((ParseTree)ctx.stateDecl(), Map.class);
        List initialStates = (List)this.getValue((ParseTree)ctx.initialDecl(), List.class);
        List acceptStates = (List)this.getValue((ParseTree)ctx.acceptDecl(), List.class);
        if (initialStates.size() != 1) {
            throw new RuntimeException("Multiple initial states are not supported yet!");
        }
        for (String aS : acceptStates) {
            State state = (State)states.get(aS);
            if (state == null) {
                throw new RuntimeException("The accepting state " + aS + " is not declared in the states statement!");
            }
            AcceptingState acceptingState = this.buchiFactory.createAcceptingState();
            acceptingState.setName(aS);
            states.put(aS, acceptingState);
        }
        ArrayList<State> initialStateList = new ArrayList<State>();
        for (String iS : initialStates) {
            State state = (State)states.get(iS);
            if (state == null) {
                throw new RuntimeException("The initial state " + iS + " is not declared in the states statement!");
            }
            initialStateList.add(state);
        }
        automaton.getStates().addAll(states.values());
        automaton.setInitial((State)initialStateList.get(0));
        for (LTLParser.TransitionDeclContext transitionDeclContext : ctx.transitionDecl()) {
            GuardedTransition transition = (GuardedTransition)this.getValue((ParseTree)transitionDeclContext, GuardedTransition.class);
            State iFrom = transition.getFrom();
            State from = (State)states.get(iFrom.getName());
            transition.setFrom(from);
            State iTo = transition.getTo();
            State to = (State)states.get(iTo.getName());
            transition.setTo(to);
            automaton.getTransitions().add((Object)transition);
        }
        this.setValue((ParseTree)ctx, automaton);
    }

    @Override
    public void exitBuchiDecl(LTLParser.BuchiDeclContext ctx) {
        BuchiDeclaration buchiDeclaration = this.buchiFactory.createBuchiDeclaration();
        if (ctx.letDecl() != null) {
            LetExpression let = (LetExpression)this.getValue((ParseTree)ctx.letDecl(), LetExpression.class);
            buchiDeclaration.getDeclarations().addAll((Collection)let.getDeclarations());
        }
        buchiDeclaration.setAutomaton((Buchi)this.getValue((ParseTree)ctx.automatonDecl(), Automaton.class));
        this.setValue((ParseTree)ctx, buchiDeclaration);
    }
}

