/*
 * Decompiled with CFR 0.152.
 */
package plug.simulation.trace_storage;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class TraceEntry<C, A> {
    private final TraceEntry<C, A> parent;
    private final Set<TraceEntry<C, A>> children = new HashSet<TraceEntry<C, A>>();
    private final C configuration;
    private final A action;

    public TraceEntry(C configuration) {
        this(null, configuration);
    }

    public TraceEntry(TraceEntry<C, A> parent, C configuration) {
        this(parent, configuration, null);
    }

    public TraceEntry(TraceEntry<C, A> parent, C configuration, A action) {
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
        this.configuration = configuration;
        this.action = action;
    }

    public void addChild(TraceEntry<C, A> child) {
        this.children.add(child);
    }

    public Set<TraceEntry<C, A>> getChildren() {
        return this.children;
    }

    public TraceEntry<C, A> getParent() {
        return this.parent;
    }

    public C getParentConfiguration() {
        return this.parent == null ? null : (C)this.parent.getConfiguration();
    }

    public C getConfiguration() {
        return this.configuration;
    }

    public A getAction() {
        return this.action;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TraceEntry that = (TraceEntry)o;
        return this.parent == that.parent && Objects.equals(this.configuration, that.configuration);
    }

    public int hashCode() {
        return Objects.hash(this.getParentConfiguration(), this.configuration);
    }

    public String toString() {
        if (this.getParentConfiguration() != null) {
            return Integer.toHexString(this.getParentConfiguration().hashCode()) + " -> " + Integer.toHexString(this.configuration.hashCode());
        }
        return Integer.toHexString(this.configuration.hashCode());
    }
}

