import sys
import os
from ctypes import *
from SimpleXMLRPCServer import SimpleXMLRPCServer


# Load the dll
if sys.platform.startswith('win'):
  my_dll = cdll.LoadLibrary('MyOperator.dll')
else:
  if os.path.exists('MyOperator.so'):
    my_dll = cdll.LoadLibrary(os.path.realpath('MyOperator.so'))
  else:
    sys.stderr.write("Library file MyOperator.so not found!\n")
    sys.stderr.write("Please run 'make' before starting the XML-RPC server.\n")
    sys.exit(1)
# Start the XML-RPC server
server = SimpleXMLRPCServer(('localhost', 55678))


def MyOperator(mychar, myint):
  """
    NEWTYPE MyType
      OPERATORS
      MyOperator: Character, Integer -> Character;
    ENDNEWTYPE;
  """
  #Specify the type of the return value
  my_dll.MyOperator.restype = c_char
  print '-> MyOperator', repr(mychar), repr(myint)
  # Call the dll. Parameters are given using the python ctypes.
  actual_return_value = my_dll.MyOperator(c_char(mychar), c_int(myint))
  print '<- MyOperator =', actual_return_value
  return actual_return_value

# Function for the operator has the same name as the operator in the XML-RPC server
server.register_function(MyOperator, 'MyOperator')


def MyProcedure(mychar, myint):
  """
    PROCEDURE MyProcedure
      (
      IN/OUT field1 Character, 
      field2 Integer
      ) 
    -> Boolean EXTERNAL;
  """
  print '-> MyProcedure', repr(mychar), repr(myint)
  # Use a python ctypes because it will be passed as a reference to the dll
  mychar_c = c_char(mychar)
  # Call the dll. The first parameter is by reference (byref) of the python ctypes
  actual_return_value = my_dll.MyProcedure(byref(mychar_c), c_int(myint))
  # Return value is a struct containing the actual return value and the values for
  # all IN/OUT parameters, represented as a Python dictionary
  return_value = {
    'return value': actual_return_value,  # Actual return value
    'field1'      : mychar_c.value        # IN/OUT parameter field1
  }
  print '<- MyProcedure =', actual_return_value
  return return_value

# Function for the external procedure has the name of the procedure with the
# suffix ':external_proc' in the XML-RPC server
server.register_function(MyProcedure, 'MyProcedure:external_proc')
  
server.serve_forever()
