/*
** This is the main module for the generated code. It sends messages to the running system, then waits for the answer.
** All exchanged messages are encoded in ASN.1.
**
** All sent messages as described as hexadecimal strings which is BER-encoded ASN.1 data. The BER-encoded ASN.1 data for the
** message sent by the system is also printed as a hexdecimal string by the generated executable. You can use:
** http://asn1-playground.oss.com/Default.aspx
** to check these strings. Just select "Enter manually" for the schema, then paste there the concatenation of the files
** BasicTypes.asn1 (in Types), ComplexTypes.asn1 (in Types) and RTDS-Asn1Messages.asn1 (in ccg after the code has been
** generated). Compile the schema, select "Data: HEX text" and "Type: AllMessages" in the "Data: Decode" zone, then paste
** one of the hexadecimal strings below, select "BER" and click "Decode". The decoded message parameters will appear in
** the "Console output" below.
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

/* Hexadecimal strings for messages sent to the SDL system: */
/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */

/* 'begin_line' message */
#define begin_line_message  "A2020500"
/* First point: 'add_point' message with coords (0, 0), no tags and name "origin" */
#define add_point_message1  "A01E301CA01A3018A003020100A103020100A2023100A30816066F726967696E"
/* Second point: 'add_point' message with coords (2, 0), tags "foo", "bar" & "baz" and no name */
#define add_point_message2  "A0233021A01F301DA003020102A103020100A211310F1603626172160362617A1603666F6F"
/* Third point: 'add_point_by_coords' message with coords (0, 2) */
#define add_point_message3  "A10C300AA003020100A103020102"
/* 'end_line' message */
#define end_line_message    "A3020500"


/* Data structures generated for messages; needed to be able to send a message to the running system */
#include "RTDS_messages.h"


/* Main function for the SDL system; this name is chosen via the -DRTDS_MAIN=... compiler option in the generation options */
extern int SDL_main(void);


/*
** FUNCTION ASN1_message_received:
** -------------------------------
** Called by the SDL system when it sends a message to the environment. Called by the macro RTDS_ASN1_MESSAGE_FROM_SYSTEM
** (see file ASN1_adaptation.h in package Adaptation).
** Parameters:
**  - message_number: message number, as defined in RTDS_gen.h (RTDS_message_* constants). Note that this is purely
**                    informative: the message type is embedded in the encoded ASN.1 data in all cases.
**  - count: number of bytes in the encoded ASN.1 data.
**  - buffer: encoded ASN.1 data. This is a DER-encoding of an instance of AllMessages, as defined in RTDS-Asn1Messages.asn1
*/

void ASN1_message_received(long message_number, unsigned long count, unsigned char * buffer)
  {
  unsigned long i;
  
  /* We just print the data encoded in hexadecimal and exit */
  for ( i = 0; i < count; i++ )
    printf("%02X", buffer[i]);
  printf("\n");
  
  exit(0);
  }
  

/*
** FUNCTION hex_string_to_buffer:
** ------------------------------
** Converts a hexadeciaml string to a sequence of bytes and writes them to a buffer.
** Parameters:
**  - hex_string: Hexadecimal string.
**  - nb_bytes: output parameter; contains the nuber of bytes in the encoded data.
**  - buffer: output parameter; contains the encoded data itself. Allocated by the function.
*/

static void hex_string_to_buffer(char * hex_string, unsigned long * nb_bytes, unsigned char ** buffer)
  {
  int i;
  short digit1, digit2;
  
  *nb_bytes = strlen(hex_string) / 2;
  *buffer = malloc(*nb_bytes);
  for (i = 0; i < *nb_bytes; i++)
    {
    digit1 = (short)hex_string[2 * i];
    digit1 = (digit1 >= 'A') ? (digit1 - 'A' + 10) : (digit1 - '0');
    digit2 = (short)hex_string[2 * i + 1];
    digit2 = (digit2 >= 'A') ? (digit2 - 'A' + 10) : (digit2 - '0');
    (*buffer)[i] = 16 * digit1 + digit2;
    }
#ifdef DEBUG_ASN1_BUFFER
  printf("Buffer is %d bytes long: ", *nb_bytes);
  for ( i = 0; i < *nb_bytes; i ++ )
    printf("%02X", (*buffer)[i]);
  printf("\n");
#endif
  }
  
  
/*
** MAIN FUNCTION:
** ==============
*/

int main(void)
  {
  unsigned long           nb_bytes;     /* Number of bytes in the encoded data for the current message */
  unsigned char       *   buffer;       /* Encoded data for the current message */
  
  /* Start all processes in SDL system */
  printf("Starting SDL system...\n");
  SDL_main();
  
  /* === Send messages to system: line start */
  printf("Sending 'begin_line' message\n");
  hex_string_to_buffer(begin_line_message, &nb_bytes, &buffer);
  RTDS_ASN1_MESSAGE_TO_SYSTEM(nb_bytes, buffer);
  free(buffer);
  sleep(1); /* Needed to make sure the message has been received & processed */
  
  /* === Add first point */
  printf("Sending first point ('add_point' message)\n");
  hex_string_to_buffer(add_point_message1, &nb_bytes, &buffer);
  RTDS_ASN1_MESSAGE_TO_SYSTEM(nb_bytes, buffer);
  free(buffer);
  sleep(1); /* Needed to make sure the message has been received & processed */
  
  /* === Add second point */
  printf("Sending second point ('add_point' message)\n");
  hex_string_to_buffer(add_point_message2, &nb_bytes, &buffer);
  RTDS_ASN1_MESSAGE_TO_SYSTEM(nb_bytes, buffer);
  free(buffer);
  sleep(1); /* Needed to make sure the message has been received & processed */
  
  /* === Add third point */
  printf("Sending third point ('add_point_by_coords' message)\n");
  hex_string_to_buffer(add_point_message3, &nb_bytes, &buffer);
  RTDS_ASN1_MESSAGE_TO_SYSTEM(nb_bytes, buffer);
  free(buffer);
  sleep(1); /* Needed to make sure the message has been received & processed */
  
  /* === Line end */
  printf("Sending 'end_line' message\n");
  hex_string_to_buffer(end_line_message, &nb_bytes, &buffer);
  RTDS_ASN1_MESSAGE_TO_SYSTEM(nb_bytes, buffer);
  free(buffer);
  
  /* Process p runs in a thread and will send back the 'line' message via the send_ASN1_message above; just wait for it */
  printf("Waiting for answer...\n");
  for ( ; ; )
    {
    sleep(3600);
    }
  
  return 1;
  }
