#ifndef _RTDS_SUT_INTERFACE_H_
#define _RTDS_SUT_INTERFACE_H_

#include "SUT.h"

extern SUT_class * SUT;

int SUT_init(void);

/* **************************************************************** *
 *                      COMMUNICATION MACRO
 * **************************************************************** *
 * A macro for each port of the TSI is generated in TTCN. 
 * **************************************************************** *
 * Parameters:
 *     MESSAGE_HEADER : RTDS_MessageHeader *  message sent by the TTCN test.
 * Returns:
 *     Nothing
 * **************************************************************** */

/*
 * MACRO RTDS_TTCN_SEND_MESSAGE_VIA_TSI_PORT_sut_port_1
 * ----------------------------------------------------
 * Send a message to the SUT via sut_port_1 of the TSI.
 * 
 * Several messages can be sent via this port.
 */
#define RTDS_TTCN_SEND_MESSAGE_VIA_TSI_PORT_sut_port_1(MESSAGE_HEADER) \
  switch (MESSAGE_HEADER->messageNumber) {\
    case RTDS_message_mRequest_1: \
      SUT->handleRequestMessage_1(((mRequest_1*)(MESSAGE_HEADER->pData))->param1); \
      break; \
    case RTDS_message_mRequest_2: \
      SUT->handleRequestMessage_2(((mRequest_2*)(MESSAGE_HEADER->pData))->param1,((mRequest_2*)(MESSAGE_HEADER->pData))->param2); \
      break; \
    }
/*
 * MACRO RTDS_TTCN_SEND_MESSAGE_VIA_TSI_PORT_sut_port_2
 * ----------------------------------------------------
 * Send a message to the SUT via sut_port_2 of the TSI.
 */
#define RTDS_TTCN_SEND_MESSAGE_VIA_TSI_PORT_sut_port_2(MESSAGE_HEADER) \
  switch (MESSAGE_HEADER->messageNumber) {\
    case RTDS_message_mRequest_3: \
      SUT->handleRequestMessage_3(((mRequest_3*)(MESSAGE_HEADER->pData))->param1, ((mRequest_3*)(MESSAGE_HEADER->pData))->param2); \
      break; \
    case RTDS_message_mRequest_4: \
      SUT->handleRequestMessage_4(((mRequest_4*)(MESSAGE_HEADER->pData))->param1, ((mRequest_4*)(MESSAGE_HEADER->pData))->param2); \
      break; \
    }

#endif 
