/* Copyright 2013 Humboldt University of Berlin
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*
* Author: Mihal Brumbulli <mbrumbulli@gmail.com>
*/

#ifndef _MAIN_WINDOW_H_
#define _MAIN_WINDOW_H_

class MainWindow 
{
  public:
    static int    id;         // Window id
    static int    width;      // Window width
    static int    height;     // Window height
    static int    xPos;       // Horizontal position in RootWindow
    static int    yPos;       // Vertical position in RootWindow
	
    static double zoomFactor; // Current zoom factor
    static double xMove;      // Horizontal movement
    static double yMove;      // Vertical movement
    static double xBegin;     // Begining of horizontal movement
    static double yBegin;     // Begining of vertical movement
    static bool   isMoving;   // Toogle movement
    
    static bool   showInfo;   // Toggle node information display 
    
    static void Create();
    static void Display();
    static void Reshape();
    static void OnSpecialKeyPress(int key, int x, int y);
    static void OnKeyPress(unsigned char key, int x, int y);
    static void OnMouseClick(int button, int state, int x, int y);
    static void OnMouseMove(int x, int y);
};

#endif



