/* Copyright 2013 Humboldt University of Berlin
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*
* Author: Mihal Brumbulli <mbrumbulli@gmail.com>
*/

#include "demoddix.h"

static unsigned char icons[][icon_size * icon_size] = {
  {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x06, 0x00,
  0x00, 0x07, 0x00, 0x80, 0x07, 0x00, 0xc0, 0x07, 0x00, 0xe0, 0x07, 0x00,
  0xf0, 0x07, 0x00, 0xe0, 0x07, 0x00, 0xc0, 0x07, 0x00, 0x80, 0x07, 0x00,
  0x00, 0x07, 0x00, 0x00, 0x06, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0xc0, 0x00, 0x00,
  0xc0, 0x01, 0x00, 0xc0, 0x03, 0x00, 0xc0, 0x07, 0x00, 0xc0, 0x0f, 0x00,
  0xc0, 0x1f, 0x00, 0xc0, 0x0f, 0x00, 0xc0, 0x07, 0x00, 0xc0, 0x03, 0x00,
  0xc0, 0x01, 0x00, 0xc0, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x40, 0x00,
  0xc0, 0x60, 0x00, 0xe0, 0x70, 0x00, 0xf0, 0x78, 0x00, 0xf8, 0x7c, 0x00,
  0xfc, 0x7e, 0x00, 0xf8, 0x7c, 0x00, 0xf0, 0x78, 0x00, 0xe0, 0x70, 0x00,
  0xc0, 0x60, 0x00, 0x80, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x00,
  0x0c, 0x06, 0x00, 0x1c, 0x0e, 0x00, 0x3c, 0x1e, 0x00, 0x7c, 0x3e, 0x00,
  0xfc, 0x7e, 0x00, 0x7c, 0x3e, 0x00, 0x3c, 0x1e, 0x00, 0x1c, 0x0e, 0x00,
  0x0c, 0x06, 0x00, 0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x3f, 0x00,
  0xf8, 0x3f, 0x00, 0xf8, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03, 0x00,
  0x80, 0x03, 0x00, 0x80, 0x03, 0x00, 0x80, 0x03, 0x00, 0xf8, 0x3f, 0x00,
  0xf8, 0x3f, 0x00, 0xf8, 0x3f, 0x00, 0x80, 0x03, 0x00, 0x80, 0x03, 0x00,
  0x80, 0x03, 0x00, 0x80, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x7f, 0x00, 0xfc, 0x7f, 0x00,
  0x0c, 0x60, 0x00, 0x0c, 0x60, 0x00, 0x0c, 0x60, 0x00, 0x00, 0x60, 0x00,
  0x00, 0x60, 0x00, 0x10, 0x60, 0x00, 0x18, 0x60, 0x00, 0xfc, 0x7f, 0x00,
  0xfc, 0x7f, 0x00, 0x18, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x7c, 0x00, 0x7c, 0x7c, 0x00,
  0x0c, 0x60, 0x00, 0x0c, 0x60, 0x00, 0x0c, 0x60, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x60, 0x00, 0x0c, 0x60, 0x00,
  0x0c, 0x60, 0x00, 0x7c, 0x7c, 0x00, 0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00},
  {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x07, 0x00, 0x80, 0x03, 0x00,
  0x80, 0x03, 0x00, 0x80, 0x03, 0x00, 0x80, 0x03, 0x00, 0x80, 0x03, 0x00,
  0x80, 0x03, 0x00, 0xc0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x80, 0x03, 0x00, 0x80, 0x03, 0x00, 0x80, 0x03, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00}
};

int           ToolbarWindow::width;
int           ToolbarWindow::height;
int           ToolbarWindow::xPos;
int           ToolbarWindow::yPos;
ToolbarButton ToolbarWindow::buttons[9];

// Create window
void ToolbarWindow::Create() 
  {
  ToolbarWindow::width = Window::STATE_W;
  ToolbarWindow::height = Window::PROGRESS_H;
  ToolbarWindow::xPos = Window::PADDING;
  ToolbarWindow::yPos = Window::PADDING;
  // Prev
  double pos = Window::PROGRESS_H / 2.0;
  ToolbarWindow::buttons[0].position = pos;
  ToolbarWindow::buttons[0].icon = icons[0];
  // Next
  pos += Window::PROGRESS_H + Window::PADDING;
  ToolbarWindow::buttons[1].position = pos;
  ToolbarWindow::buttons[1].icon = icons[1];
  // Rewind
  pos += Window::PROGRESS_H + 4 * Window::PADDING;
  ToolbarWindow::buttons[2].position = pos;
  ToolbarWindow::buttons[2].icon = icons[2];
  // Forward
  pos += Window::PROGRESS_H + Window::PADDING;
  ToolbarWindow::buttons[3].position = pos;
  ToolbarWindow::buttons[3].icon = icons[3];
  // Step up
  pos += Window::PROGRESS_H + 4 * Window::PADDING;
  ToolbarWindow::buttons[4].position = pos;
  ToolbarWindow::buttons[4].icon = icons[4];
  // Step down
  pos += Window::PROGRESS_H + Window::PADDING;
  ToolbarWindow::buttons[5].position = pos;
  ToolbarWindow::buttons[5].icon = icons[5];
  // Reset
  pos += Window::PROGRESS_H + 4 * Window::PADDING;
  ToolbarWindow::buttons[6].position = pos;
  ToolbarWindow::buttons[6].icon = icons[6];
  // Fit zoom
  pos += Window::PROGRESS_H + Window::PADDING;
  ToolbarWindow::buttons[7].position = pos;
  ToolbarWindow::buttons[7].icon = icons[7];
  // Show/hide info
  pos += Window::PROGRESS_H + Window::PADDING;
  ToolbarWindow::buttons[8].position = pos;
  ToolbarWindow::buttons[8].icon = icons[8];
  }

// Draw toolbar
void ToolbarWindow::Display() 
  {
  // Viewport
  glViewport(ToolbarWindow::xPos, ToolbarWindow::yPos, ToolbarWindow::width, ToolbarWindow::height);
  glScissor(ToolbarWindow::xPos, ToolbarWindow::yPos, ToolbarWindow::width, ToolbarWindow::height);
  glEnable(GL_SCISSOR_TEST);
  glLoadIdentity();
  glLineWidth(1.0f);
  // Ratio for mapping pixels to coordinates
  double xRatio = 2.0 / ToolbarWindow::width;
  double yRatio = 2.0 / ToolbarWindow::height;
  // Needed for bitmaps
  glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
  glPixelStorei(GL_UNPACK_LSB_FIRST, 1);
  // Draw
  double y = 1.0 - (Window::PROGRESS_H / 2.0) * yRatio;
  double yIcon = y - (icon_size / 2.0) * yRatio;
  for (int i = 0; i < 9; ++i)
    {
    double x = -1.0 + ToolbarWindow::buttons[i].position * xRatio;
    double xIcon = x - (icon_size / 2.0) * xRatio;
    // Draw border
    glColor3ub(Window::BD_COLOR[0], Window::BD_COLOR[1], Window::BD_COLOR[2]);
    glPointSize(Window::PROGRESS_H);
    glBegin(GL_POINTS);
      glVertex2d(x, y);
    glEnd();
    // Draw button
    glColor3ub(Window::BG_COLOR[0], Window::BG_COLOR[1], Window::BG_COLOR[2]);
    glPointSize(Window::PROGRESS_H - 2);
    glBegin(GL_POINTS);
      glVertex2d(x, y);
    glEnd();
    // Draw icon
    glColor3ub(Window::FG_COLOR[0], Window::FG_COLOR[1], Window::FG_COLOR[2]);
    glRasterPos2d(xIcon, yIcon);
    glBitmap(icon_size, icon_size, 0.0, 0.0, 0.0, 0.0, ToolbarWindow::buttons[i].icon);
    }
  // Disable crop
  glDisable(GL_SCISSOR_TEST);
  }

// Handle mouse click
void ToolbarWindow::OnMouseClick(int button, int state, int x, int y) 
  {
  // Only left click
  if (!(button == GLUT_LEFT_BUTTON && state == GLUT_DOWN)) 
    {
    return;
    }
  // Update click coordinate based on window position (viewport)
  x -= Window::PADDING;
  // Find clicked button
  int i;
  for (i = 0; i < 9; ++i)
    {
    double xMin = ToolbarWindow::buttons[i].position - Window::PROGRESS_H / 2.0;
    double xMax = ToolbarWindow::buttons[i].position + Window::PROGRESS_H / 2.0;
    if (x >= xMin && x <= xMax)
      {
      break;
      }
    }
  // Handle event via main window
  switch (i)
    {
    case 0:
      MainWindow::OnSpecialKeyPress(GLUT_KEY_DOWN, 0, 0);
      break;
    case 1:
      MainWindow::OnSpecialKeyPress(GLUT_KEY_UP, 0, 0);
      break;
    case 2:
      MainWindow::OnSpecialKeyPress(GLUT_KEY_LEFT, 0, 0);
      break;
    case 3:
      MainWindow::OnSpecialKeyPress(GLUT_KEY_RIGHT, 0, 0);
      break;
    case 4:
      MainWindow::OnSpecialKeyPress(GLUT_KEY_PAGE_DOWN, 0, 0);
      break;
    case 5:
      MainWindow::OnSpecialKeyPress(GLUT_KEY_PAGE_UP, 0, 0);
      break;
    case 6:
      MainWindow::OnKeyPress('r', 0, 0);
      break;
    case 7:
      MainWindow::OnSpecialKeyPress(GLUT_KEY_HOME, 0, 0);
      break;
    case 8:
      MainWindow::OnKeyPress('i', 0, 0);
      break;
    }
  }
