/* Copyright 2013 Humboldt University of Berlin
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*
* Author: Mihal Brumbulli <mbrumbulli@gmail.com>
*/

#include <climits>
#include <string>

#include "demoddix.h"


int MessageColorWindow::width;
int MessageColorWindow::height;
int MessageColorWindow::xPos;
int MessageColorWindow::yPos;

// Create window
void MessageColorWindow::Create() 
  {
  MessageColorWindow::width = 8 * Window::POINT;
  MessageColorWindow::height = 13 * Window::POINT;
  MessageColorWindow::xPos = Window::STATE_W - MessageColorWindow::width;
  MessageColorWindow::yPos = MessageWindow::yPos + MessageWindow::height - (MessageColorWindow::height + Window::PADDING);
  }

// Draw color chooser
void MessageColorWindow::Display() 
  {
  // Vieport and crop
  glViewport(MessageColorWindow::xPos, MessageColorWindow::yPos, MessageColorWindow::width, MessageColorWindow::height);
  glScissor(MessageColorWindow::xPos, MessageColorWindow::yPos, MessageColorWindow::width, MessageColorWindow::height);
  glEnable(GL_SCISSOR_TEST);
  glLoadIdentity();
  glLineWidth(1.0f);
  // Ratio for mapping pixels to coordinates
  double yRatio = 2.0 / MessageColorWindow::height;
  double xRatio = 2.0 / MessageColorWindow::width;
  // Draw color map
  glPointSize(Window::POINT);
  glBegin(GL_POINTS);
  for (int x = 0; x < 8; ++x) 
    {
    for (int y = 0; y < 13; ++y) 
      {
      int c = x * 13 + y;
      glColor3ub(Window::COLOR[c][0], Window::COLOR[c][1], Window::COLOR[c][2]);
      glVertex2d(-1.0 + (x + 0.5) * Window::POINT * xRatio, 1.0 - (y + 0.5) * Window::POINT * yRatio);
      }
    }
  glEnd();
  // Draw border
  glLoadIdentity();
  glLineWidth(2.0f);
  glColor3ub(Window::BD_COLOR[0], Window::BD_COLOR[1], Window::BD_COLOR[2]);
  glBegin(GL_LINE_LOOP);
    glVertex2d(-1.0, -1.0); // bottom left
    glVertex2d(1.0, -1.0); // bottom right
    glVertex2d(1.0, 1.0); // top right
    glVertex2d(-1.0, 1.0); // top left
  glEnd();
  // Disable crop
  glDisable(GL_SCISSOR_TEST);
  }

// Handle window resize
void MessageColorWindow::Reshape() 
  {
  MessageColorWindow::yPos = MessageWindow::yPos + MessageWindow::height - (MessageColorWindow::height + Window::PADDING);
  }

// Handle mouse click
void MessageColorWindow::OnMouseClick(int button, int state, int x, int y) 
  {
  // Left mouse sets color to selected message and hides color chooser
  if (button == GLUT_LEFT_BUTTON && state == GLUT_DOWN) 
    {
    x = (x - MessageColorWindow::xPos) / Window::POINT;
    y = (y - MessageWindow::height - 3 * Window::PADDING) / Window::POINT;
    if (MessageWindow::selectedMessage != ULONG_MAX) 
      {
      Demoddix::messageList[MessageWindow::selectedMessage].color = x * 13 + y;
      MessageWindow::selectedMessage = ULONG_MAX;
      }
    }
  // Right mouse hides color chooser
  else if (button == GLUT_RIGHT_BUTTON && state == GLUT_DOWN) 
    {
    MessageWindow::selectedMessage = ULONG_MAX;
    }
  // Update view
  glutPostRedisplay();
  }
