/* Copyright 2013 Humboldt University of Berlin
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>.
*
* Author: Mihal Brumbulli <mbrumbulli@gmail.com>
*/

#include "demoddix.h"


int RootWindow::width;
int RootWindow::height;
int RootWindow::xPos;
int RootWindow::yPos;

// Create window
void RootWindow::Create() 
  {
  RootWindow::width = Window::ROOT_W;
  RootWindow::height = Window::ROOT_H;
  RootWindow::xPos = 0;
  RootWindow::yPos = 0;
  // Initialize and event binding
  glutInitWindowPosition(RootWindow::xPos, RootWindow::yPos);
  glutInitWindowSize(RootWindow::width, RootWindow::height);
  glutCreateWindow("PragmaDev Deployment Simulator");
  glClearColor(Window::BG_COLOR[0] / 255.0, Window::BG_COLOR[1] / 255.0, Window::BG_COLOR[2] / 255.0, 1.0);
  glEnable(GL_BLEND); 
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  glutDisplayFunc(RootWindow::Display);
  glutReshapeFunc(RootWindow::Reshape);
  glutSpecialFunc(RootWindow::OnSpecialKeyPress);
  glutKeyboardFunc(RootWindow::OnKeyPress);
  glutIdleFunc(RootWindow::Idle);
  glutMouseFunc(RootWindow::OnMouseClick);
  glutMotionFunc(RootWindow::OnMouseMove);
  // Create all contained windows
  StateWindow::Create();
  MessageWindow::Create();
  ToolbarWindow::Create();
  MainWindow::Create();
  ProgressWindow::Create();
  }

// Draw borders for all other windows
void RootWindow::Display() 
  {
  glViewport(0, 0, RootWindow::width, RootWindow::height);
  glClear(GL_COLOR_BUFFER_BIT);
  // Display all contained windows
  StateWindow::Display();
  MessageWindow::Display();
  ToolbarWindow::Display();
  MainWindow::Display();
  ProgressWindow::Display();
  // Update view
  glutSwapBuffers();
  }

// Handle window resize
void RootWindow::Reshape(int w, int h)
  {
  // Make sure window is not smaller than minimal size
  RootWindow::width = std::max(w, Window::ROOT_W);
  RootWindow::height = std::max(h, Window::ROOT_H);
  // Update all contained windows
  StateWindow::Reshape();
  MessageWindow::Reshape();
  MainWindow::Reshape();
  ProgressWindow::Reshape();
  // Update view
  if (w < Window::ROOT_W || h < Window::ROOT_H)
    {
    glutReshapeWindow(RootWindow::width, RootWindow::height);
    }
  glutPostRedisplay();
  }

// Handle special key press
void RootWindow::OnSpecialKeyPress(int key, int x, int y)
  {
  // Handle only in main window
  MainWindow::OnSpecialKeyPress(key, x, y);
  }

// Handle special key press
void RootWindow::OnKeyPress(unsigned char key, int x, int y)
  {
  // Handle only in main window
  MainWindow::OnKeyPress(key, x, y);
  }

void RootWindow::OnMouseClick(int button, int state, int x, int y)
  {
  // Handle it in main window
  if (x >= MainWindow::xPos && x <= MainWindow::xPos + MainWindow::width && y >= Window::PADDING && y <= Window::PADDING + MainWindow::height)
    {
    MainWindow::OnMouseClick(button, state, x, y);
    }
  // Handle it in state window
  else if (x >= StateWindow::xPos && x <= StateWindow::xPos + StateWindow::width && y >= Window::PADDING && y <= Window::PADDING + StateWindow::height)
    {
    StateWindow::OnMouseClick(button, state, x, y);
    }
  // Handle it in message window
  else if (x >= MessageWindow::xPos && x <= MessageWindow::xPos + MessageWindow::width && y >= MessageWindow::height + 2 * Window::PADDING && y <= 2 * MessageWindow::height + 2 * Window::PADDING)
    {
    MessageWindow::OnMouseClick(button, state, x, y);
    }
  // Handle it in toolbar window
  else if (x >= ToolbarWindow::xPos && x <= ToolbarWindow::xPos + ToolbarWindow::width && y >= RootWindow::height - (ToolbarWindow::height + Window::PADDING) && y <= RootWindow::height - Window::PADDING)
    {
    ToolbarWindow::OnMouseClick(button, state, x, y);
    }
  }

// Handle mouse move
void RootWindow::OnMouseMove(int x, int y) 
  {
  // Handle only in main window
  MainWindow::OnMouseMove(x, y);
  }

// Check simulator status
void RootWindow::Idle()
  {
  // Handle only in progress window
  ProgressWindow::Idle();
  }
