#include "RTDS_Scheduler.h"


/*
** FUNCTION RTDS_Scheduler_start:
** ------------------------------
** Function used as entry point for a task running a given scheduler
*/
static void * RTDS_Scheduler_start(void * RTDS_Scheduler_instance)
  {
  /* Run the instance */
  RTDS_Scheduler_run((RTDS_Scheduler*)RTDS_Scheduler_instance);
  return NULL;
  }

/*
** VARIABLE RTDS_SystemScheduler:
** ------------------------------
** The one and only scheduler for the whole system.
*/
RTDS_Scheduler * RTDS_SystemScheduler = NULL;

/*
** MACRO RTDS_SCHEDULER_START:
** ---------------------------
** Creates a task running a scheduler
*/
#define RTDS_SCHEDULER_START(SCHEDULER_INSTANCE) \
  RTDS_CREATE_TASK(RTDS_DEFAULT_PROCESS_PRIORITY, &RTDS_Scheduler_start, SCHEDULER_INSTANCE)

/*
** MACRO RTDS_SCHEDULER_NEW:
** -------------------------
** Creates a new scheduler. "Overloaded" from RTDS_Scheduler.h to ensure that there is always
** one and only one scheduler for the whole system.
*/
#undef RTDS_SCHEDULER_NEW
#define RTDS_SCHEDULER_NEW RTDS_SystemScheduler
