#include "RTDS_Env.h"
#include "RTDS_Scheduler.h"
#include "RTDS_InstanceManager.h"
#include "RTDS_Common.h"
#include "RTDS_ADDL_MACRO.h"

#include "RTDS_gen.h"

#define RTDS_PROCESS_NUMBER RTDS_process_RTDS_Env
#define RTDS_PROCESS_NAME RTDS_Env


RTDS_Env_proc::RTDS_Env_proc(RTDS_Scheduler *parentScheduler): RTDS_Proc(parentScheduler)
  {
  }

short RTDS_Env_proc::RTDS_continuousSignals(int *lowestPriority) 
  {
  return 0;
  }

short RTDS_Env_proc::RTDS_executeTransition(RTDS_MessageHeader *currentMessage) 
  {
  // Never terminate
  return 0;
  }
	
/*
 ** INSTANCE FACTORY:
 ** -----------------
 ** Static function creating an instance of the new task and creation of a
 ** new RTDS_InstanceManager instance associating this function to the current
 ** process number.
 */

static RTDS_Proc* createInstance(RTDS_Scheduler* parentScheduler)
  {
  return new RTDS_Env_proc(parentScheduler);
  }

static RTDS_InstanceManager instanceManager(RTDS_process_RTDS_Env, &createInstance);

RTDS_TASK_ENTRY_POINT(RTDS_Env)
  {
  RTDS_SETUP_CURRENT_CONTEXT
  RTDS_Scheduler localScheduler(&(RTDS_currentContext->mySdlInstanceId->queueId));
  localScheduler.createInstance(RTDS_PROCESS_NUMBER, NULL, RTDS_currentContext);
  RTDS_START_SYNCHRO_WAIT
  localScheduler.run();
  }
