#ifndef _RTDS_INSTANCEMANAGER_H_
#define _RTDS_INSTANCEMANAGER_H_

class RTDS_Proc;
class RTDS_Scheduler;
class RTDS_InstanceManager;

typedef RTDS_Proc * (*InstanceCreationFunction)(RTDS_Scheduler*);

struct RTDS_InstanceManagerList
{
  int                                 processNumber;
  RTDS_InstanceManager              * manager;
  RTDS_InstanceManagerList          * next;
};

class RTDS_InstanceManager
{
  private:
    static RTDS_InstanceManagerList * instanceList;
    InstanceCreationFunction          creationFunction;
    
  public:
    RTDS_InstanceManager(int processNumber, InstanceCreationFunction creationFunction);
    ~RTDS_InstanceManager();
    static RTDS_Proc* createInstance(RTDS_Scheduler *parentScheduler, int processNumber);
};

#endif
