#define __STDC_FORMAT_MACROS
#include <inttypes.h>

#include "RTDS_OS.h"
#include "RTDS_Scheduler.h"
#include "RTDS_Proc.h"
#include "RTDS_Deployment.h"
#include "RTDS_Common.h"
#include "RTDS_BasicTypes.h"

FILE * RTDS_traceFile = NULL;
uint32_t RTDS_globalMessageUniqueIdPool[RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE];

int RTDS_TraceOpen(const char *fileName)
  {
  RTDS_traceFile = fopen(fileName, "wb");
  if (RTDS_traceFile == NULL)
    {
    return -1;
    }
  setbuf(RTDS_traceFile, NULL);
  fprintf(RTDS_traceFile, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<demoddix>\n");
  return 0;
  }

int RTDS_TraceClose()
  {
  if (RTDS_traceFile != NULL)
    {
    fprintf(RTDS_traceFile, "  </events>\n");
    fprintf(RTDS_traceFile, "</demoddix>\n");
    return fclose(RTDS_traceFile);
    }
  return -1;
  }

int RTDS_GetMessageUniqueId(void)
  {
  int messageUniqueId = 0;
  for (int word = 0; word < RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE; ++word)
    {
    uint32_t freeSlot = RTDS_globalMessageUniqueIdPool[word] & (-RTDS_globalMessageUniqueIdPool[word]);
    if (freeSlot)
      {
      RTDS_globalMessageUniqueIdPool[word] &= ~(-RTDS_globalMessageUniqueIdPool[word]);
      frexp(freeSlot, &messageUniqueId);
      messageUniqueId += word * 32;
      break;
      }
    }
  return messageUniqueId;
  }

void RTDS_ReleaseMessageUniqueId(int messageUniqueId)
  {
  if (messageUniqueId == 0)
    {
    return;
    }
  --messageUniqueId;
  RTDS_globalMessageUniqueIdPool[messageUniqueId / 32] += 1ul << (messageUniqueId % 32);
  }

long long RTDS_TickGet()
  {
  return (long long) ns3::Simulator::Now().GetNanoSeconds();
  }

void RTDS_TimerStop(RTDS_Proc *owner, int timerNumber)
  {
  RTDS_Scheduler *scheduler = owner->RTDS_parentScheduler;
  RTDS_SdlInstanceId &receiverId = owner->RTDS_currentContext->mySdlInstanceId;
  // Remove timer from list
  RTDS_TimerState *currTimer, *prevTimer = NULL;
  for (currTimer = scheduler->timerList; currTimer != NULL; prevTimer = currTimer, currTimer = currTimer->next)
    {
    if (currTimer->receiverId.instanceNumber == receiverId.instanceNumber && currTimer->timerNumber == timerNumber)
      {
        if (prevTimer == NULL)
          {
          scheduler->timerList = currTimer->next;
          }
        else
          {
          prevTimer->next = currTimer->next;
          }
        // Trace
        fprintf(RTDS_traceFile, "    <timerCancelled nId=\"n%u\" cId=\"c%u\" time=\"%"PRId64"\" pName=\"p%d\" timerName=\"m%d\" pId=\"%u\" tId=\"%d\" />\n",
          scheduler->component->node->nodeUniqueId,
          scheduler->component->componentUniqueId,
          RTDS_TickGet(), 
          receiverId.processNumber, 
          timerNumber, 
          receiverId.instanceNumber, 
          timerNumber
        );
        // Discard timer
        free(currTimer);
        break;
      }
    }
  }

void RTDS_TimerStart(RTDS_Proc *owner, int timerNumber, int delay)
  {
  RTDS_Scheduler *scheduler = owner->RTDS_parentScheduler;
  RTDS_SdlInstanceId &receiverId = owner->RTDS_currentContext->mySdlInstanceId;
	// Create a new timer
	RTDS_TimerState *newTimer = (RTDS_TimerState *) malloc(sizeof(RTDS_TimerState));
	newTimer->timerNumber = timerNumber;
	newTimer->receiverId = receiverId;
	// Set timeout
	newTimer->timeoutValue = RTDS_TickGet() + (long long) delay * 1000000;
	// Insert timer into the list
	RTDS_TimerState *currTimer, *prevTimer = NULL;
  for (currTimer = scheduler->timerList; currTimer != NULL; prevTimer = currTimer, currTimer = currTimer->next)
    {
    if (currTimer->timeoutValue > newTimer->timeoutValue)
      {
        // Top of list
        if (prevTimer == NULL)
          {
          newTimer->next = scheduler->timerList;
          scheduler->timerList = newTimer;
          }
        // Middle of list
        else
          {
          newTimer->next = currTimer;
          prevTimer->next = newTimer;
          }
        return;
      }
    }
  // End of list
  newTimer->next = NULL;
  if (prevTimer == NULL)
    {
    scheduler->timerList = newTimer;
    }
  else
    {
    prevTimer->next = newTimer;
    }
  // Trace
  fprintf(RTDS_traceFile, "    <timerStarted nId=\"n%u\" cId=\"c%u\" time=\"%"PRId64"\" pName=\"p%d\" timerName=\"m%d\" pId=\"%u\" tId=\"%d\" timeLeft=\"%d\" />\n",
    scheduler->component->node->nodeUniqueId,
    scheduler->component->componentUniqueId,
    RTDS_TickGet(), 
    receiverId.processNumber, 
    timerNumber, 
    receiverId.instanceNumber, 
    timerNumber, 
    delay
  );
  }

short RTDS_IsDefaultComponent(char *nodeId, char *componentId)
  {
  return 1;
  }

short RTDS_SocketStart()
  {
  return 1;
  }
  
short RTDS_SocketStop()
  {
  return 1;
  }
