#include <stdlib.h>
#include <string.h>

#include "RTDS_SemaphoreProcess.h"

RTDS_SemaphoreProcess::RTDS_SemaphoreProcess(RTDS_Scheduler* parentScheduler): RTDS_Proc(parentScheduler)
  {
  firstWaitingInstance = NULL;
  lastWaitingInstance = NULL;
  }

RTDS_SemaphoreProcess::~RTDS_SemaphoreProcess()
  {
	// Clean waiting list
	while (firstWaitingInstance != NULL)
	   {
	   RTDS_WaitingInstanceList *waitingInstance = firstWaitingInstance;
	   firstWaitingInstance = firstWaitingInstance->next;
	   free(waitingInstance);
	   }
  }

void RTDS_SemaphoreProcess::pushWaitingInstance(RTDS_SdlInstanceId &instanceId)
  {
  // Create instance
  RTDS_WaitingInstanceList *newWaitingInstance = (RTDS_WaitingInstanceList *) malloc(sizeof(RTDS_WaitingInstanceList));
  newWaitingInstance->instanceId = instanceId;
  if (firstWaitingInstance == NULL)
    {
    firstWaitingInstance = newWaitingInstance;
    lastWaitingInstance = firstWaitingInstance;
    }
  else
    {
    lastWaitingInstance->next = newWaitingInstance;
    lastWaitingInstance = lastWaitingInstance->next;
    }
  lastWaitingInstance->next = NULL;
  }

RTDS_SdlInstanceId &RTDS_SemaphoreProcess::popWaitingInstance() 
  {
  static RTDS_SdlInstanceId instanceId;
  memset(&instanceId, 0, sizeof(RTDS_SdlInstanceId));
  if (firstWaitingInstance != NULL)
    {
    RTDS_WaitingInstanceList *waitingInstance = firstWaitingInstance;
    firstWaitingInstance = firstWaitingInstance->next;
    instanceId = waitingInstance->instanceId;
    free(waitingInstance);
    if (firstWaitingInstance == NULL)
      {
      lastWaitingInstance = NULL;
      }
    }
  return instanceId;
  }

short RTDS_SemaphoreProcess::removeWaitingInstance(RTDS_SdlInstanceId &instanceId)
  {
  RTDS_WaitingInstanceList *currInstance, *prevInstance = NULL;
  for (currInstance = firstWaitingInstance; currInstance != NULL; prevInstance = currInstance, currInstance = currInstance->next)
    {
    if (currInstance->instanceId.instanceNumber == instanceId.instanceNumber)
      {
        if (prevInstance == NULL)
          {
          firstWaitingInstance = currInstance->next;
          if (firstWaitingInstance == NULL)
            {
            lastWaitingInstance = NULL;
            }
          }
        else
          {
          prevInstance->next = currInstance->next;
          if (lastWaitingInstance == currInstance)
            {
            lastWaitingInstance = prevInstance;
            }
          }
        free(currInstance);
        return 1;
      }
    }
  return 0;
  }
