/* PragmaDev RTDS OSE Epsilon integration */
#include "RTDS_OS.h"
#include "RTDS_MACRO.h"
#include "RTDS_gen.h"

static const SIGSELECT any_sig[] = {0};

/*
 * FUNCTION FOR PROCESS RTDS_Env:
 * ------------------------------
 */

RTDS_TASK_ENTRY_POINT(RTDS_Env)
	{
	RTDS_GlobalProcessInfo	*RTDS_currentContext, *RTDS_tmpContext;

	/* Get the task context from RTDS_globalProcessInfo chained list */
	RTDS_CRITICAL_SECTION_START;
	
	/* Add currentContext to the end of the list */
	RTDS_currentContext = (RTDS_GlobalProcessInfo *) RTDS_MALLOC(sizeof(RTDS_GlobalProcessInfo));
	if ( RTDS_globalProcessInfo == NULL)
		RTDS_globalProcessInfo = RTDS_currentContext;
	else
		{
		for (RTDS_tmpContext=RTDS_globalProcessInfo;RTDS_tmpContext->next!=0;RTDS_tmpContext=RTDS_tmpContext->next);
		RTDS_tmpContext->next=RTDS_currentContext;
		}

	RTDS_currentContext->sdlProcessNumber = RTDS_process_RTDS_Env;
	RTDS_currentContext->myRtosTaskId = current_process();
  RTDS_currentContext->mySdlInstanceId = ( RTDS_SdlInstanceId * )RTDS_MALLOC( sizeof( RTDS_SdlInstanceId ) );
  RTDS_currentContext->mySdlInstanceId->queueId = current_process();
  RTDS_currentContext->mySdlInstanceId->instanceNumber = 0;
	RTDS_currentContext->sdlState = 0;
	RTDS_currentContext->currentMessage = NULL;
	RTDS_currentContext->timerList = NULL;
	#if defined(RTDS_SIMULATOR) || defined(RTDS_MSC_TRACE) || defined(RTDS_FORMAT_TRACE)
		RTDS_currentContext->priority = get_pri(current_process());
	#endif
	RTDS_currentContext->next = NULL;
	
	RTDS_CRITICAL_SECTION_STOP;

	RTDS_SDL_STATE_SET(RTDS_state_RTDS_Idle);

	/* Event loop */
	for ( ; ; )
		{
		/* Get message from process's message queue */
		RTDS_MSG_QUEUE_READ(RTDS_currentContext->currentMessage);
		RTDS_currentContext->currentMessage->next = NULL;

		#ifdef RTDS_SIMULATOR
			RTDS_messageDataToString(
				&RTDS_globalPrintableParameters,
				RTDS_currentContext->currentMessage->messageNumber,
				RTDS_currentContext->currentMessage->dataLength,
				(void *)(RTDS_currentContext->currentMessage->pData),
				RTDS_PARAM_CODEC_MAX_DEPTH);
			RTDS_SIMULATOR_TRACE(RTDS_messageReceived, RTDS_currentContext->currentMessage, SELF, RTDS_currentContext);
			RTDS_FREE(RTDS_globalPrintableParameters);
			RTDS_globalPrintableParameters = NULL;
			/* Release the message unique id back to the pool */
			RTDS_ReleaseMessageUniqueId(RTDS_currentContext->currentMessage->messageUniqueId);
		#endif

		#ifdef RTDS_ENV_FREE_PARAMETER
			if (RTDS_currentContext->currentMessage->pData!=NULL)
				RTDS_FREE(RTDS_currentContext->currentMessage->pData);
		#endif

		/* Free memory */
		free_buf((union SIGNAL **)&(RTDS_currentContext->currentMessage));
		RTDS_currentContext->currentMessage = NULL;

		} /* End of for ( ; ; ) */

	/* Resources clean up */
	RTDS_PROCESS_KILL;
	}

