/* PragmaDev RTDS posix integration */
/* List of errors returned by RTDS 'kernel' */

/* SYSTEM ERROR*/
#define RTDS_ERROR_STARTUP_CONTEXT_MALLOC                      0x0002 /* startup task could not allocate memory for current context */
#define RTDS_ERROR_MALLOC                                      0x0003 /* Malloc return a NULL pointer */
#define RTDS_TCPEVENT_BIND_ERROR                               0x0008 /* error if failing when creating binding socket for sending tcp event to an external program*/
#define RTDS_TCPEVENT_CONNEXION_ERROR                          0x0008 /* error if failing when creating socket connexion for sending tcp event to an external program*/

#define RTDS_ERROR_TCP_THREAD                                  0x0009
  /* Failed when creating TCP Client thread : on linux check if you have superuser
   * privilege when using RTDS_THREAD_PRIO_ENABLE macro
   */
   
/* SOCKET */
#define RTDS_ERROR_SOCKET_CONNECTION                           0x0010
#define RTDS_ERROR_CLOSE_SOCKET                                0x0001
#define RTDS_ERROR_RECV                                        0x0004 /* error when receive a message over socket */
#define RTDS_ERROR_SEND                                        0x0005 /* error when send a message over socket */
   /* Wrong socket port: check socket port value (-DRTDS_SOCKET_PORT)
   * should be the same as RTDS environnement variable called RTDS_SOCKET_PORT
   */

/* TIMER */
#define RTDS_ERROR_NO_MORE_TIMER_UNIQUE_ID                     0x0011
#define RTDS_ERROR_MSG_Q_SEND_IN_WATCHDOG                      0x0012
#define RTDS_ERROR_WATCHDOG_CREATION                           0x0013
#define RTDS_ERROR_WATCHDOG_START                              0x0014
#define RTDS_ERROR_MSG_QUEUE_SEND                              0x0015 /* Error sending message (when calling OS primitive)*/
#define RTDS_ERROR_MALLOC_TIMER_STATE_IN_START_TIMER           0x0016
#define RTDS_ERROR_TIMER_TO_STOP_NOT_FOUND                     0x0017
#define RTDS_ERROR_TIMER_INCONSISTANT                          0x0018 /* parameters in the header are not consistant with a timer message */
#define RTDS_ERROR_TIMER_DELETE                                0x0019 /* Error when trying to delete timer */

/* TASK */
#define RTDS_ERROR_TASK_DELETE                                 0x0020
#define RTDS_ERROR_TASK_TO_DELETE_NOT_FOUND                    0x0021 /* The task to delete was not found in the globalProcessInfoList */
#define RTDS_ERROR_MSG_QUEUE_DELETE                            0x0022
#define RTDS_ERROR_PROCESS_CREATE_MALLOC                       0x0023
#define RTDS_ERROR_PROCESS_CREATE_MSG_Q_CREATE                 0x0024
#define RTDS_ERROR_PROCESS_CREATE_TASK_SPAWN                   0x0025 /* Error creating task */
#define RTDS_ERROR_PROCESS_NAME_NULL                           0x0026 /* process name length null */
#define RTDS_ERROR_PROCESS_NAME_TOO_LONG                       0x0027 /* process name too long */
#define RTDS_ERROR_GET_PROCESS_QUEUE_ID                        0x0028 /* process name not found */

/* SEMAPHORE */
#define RTDS_ERROR_SEM_INFO_INSERT_MALLOC                      0x0030
#define RTDS_ERROR_SEM_INFO_INSERT                             0x0031
#define RTDS_ERROR_GET_SEMAPHORE_ID                            0x0032 /* semaphore name not found */
#define RTDS_ERROR_SEM_CREATE                                  0x0033 /* Error creating semaphore*/
#define RTDS_ERROR_SEM_FLUSH                                   0x0034 /* Error when flushing semaphore */
#define RTDS_ERROR_SEM_DELETE                                  0x0035 /* Error when deleting a semaphore */
#define RTDS_ERROR_SEM_TAKE                                    0x0036 /* Error when taking a semaphore */
#define RTDS_ERROR_SEMID_GIVE                                  0x0037 /* Error when give the semaphore in RTDS_SemaphoreIdGive */
#define RTDS_ERROR_IS_SEM_AVAILABLE                            0x0038 /* Error when give the semaphore in RTDS_IsSemaphoreAvailable */
#define RTDS_ERROR_SEM_TAKE_TIMEOUT_VALUE                      0x0039 /* Error when timeout value is not 0 or FOREVER */

/* MESSAGE*/
#define RTDS_ERROR_NO_MORE_MSG_UNIQUE_ID                       0x0040 /* No more message unique id available. Increase RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE */
#define RTDS_ERROR_MSG_RECEIVE                                 0x0041 /* No more message unique id available. Increase RTDS_MESSAGE_UNIQUE_ID_POOL_SIZE */
#define RTDS_ERROR_QUEUEID                                     0x0042 /* Try to send message to a not valid QueueId*/
#define RTDS_ERROR_MSG_INPUT                                   0x0043
#define RTDS_ERROR_MSGQ_READ                                   0x0044 /* Error when give the semaphore in RTDS_MsgQRead */

/* ERROR RELATED TO THE DYNAMIC TRACE */
#define RTDS_ERROR_FORMATING_TRACE                             0x0050 /* error formating trace */
#define RTDS_ERROR_TRACE_PROCESS_INFO                          0x0051 /* Process information to available */
#define RTDS_ERROR_GET_PROCESS_FROM_PROCESS_ID                 0x0053 /* can't find process that own the specified processId */
#define RTDS_ERROR_EXTEND_MEMORY_ALLOC                         0x0054 /* Error while trying to extend memory allocation */

/* ERROR RELATED TO THE BACKTRACE */
#define RTDS_ERROR_BACK_TRACE_NOT_ENOUGH_MEMORY                0x1002 /* There is not enough memory to store all the events in RAM. Reduce RTDS_BACK_TRACE_MAX_EVENT_NUM or RTDS_BACK_TRACE_MESSAGE_DATA_SIZE */

/* ERROR RELATED TO THE PROFILE FUNCTIONS */
#define RTDS_ERROR_WRONG_PRIORITY_VALUE                        0x0100 /* The priority value defined for the SDL process is out of range for the OS */
#define RTDS_ERROR_PTHREAD_ATTR_INIT                           0x0101 /* Error in pthread_attr_init */
#define RTDS_ERROR_PTHREAD_SETSCHEDPOLICY                      0x0102 /* Error in pthread_attr_setschedpolicy */
#define RTDS_ERROR_PTHREAD_ATTR_SETSCHEDPARAM                  0x0103 /* Error in pthread_attr_setschedparam */
#define RTDS_ERROR_PTHREAD_ATTR_DESTROY                        0x0104 /* Error in pthread_attr_destroy */
#define RTDS_ERROR_PTHREAD_CREATE                              0x0105 /* Error in pthread_create */
#define RTDS_ERROR_PTHREAD_MUTEX_INIT                          0x0106 /* Error in pthread_mutex_init */
#define RTDS_ERROR_SEM_INIT                                    0x0107 /* Error in sem_init */
#define RTDS_ERROR_PTHREAD_ATTR_SETDETACH                      0x0108 /* Error in pthread_attr_setdetachstate */
#define RTDS_ERROR_PTHREAD_CANCEL                              0x0109 /* Error in pthread_cancel */
#define RTDS_ERROR_GETTIME                                     0x0110 /* Error in gettimeofday */

/* ERROR RELATED TO TTCN 3 EXECUTION */
#define RTDS_ERROR_COMPONENT_NOT_FOUND                         0x0200 /* Can not find component */
#define RTDS_ERROR_PORT_NOT_FOUND                              0x0201 /* Can not find component port */
#define RTDS_ERROR_PORT_NOT_CONNECTED                          0x0202 /* Port to deconnect are not connected */
#define RTDS_ERROR_MAP_NOT_SYSTEM                              0x0203 /* map or unmap action with no system component */
#define RTDS_ERROR_CONNECT_ON_SYSTEM                           0x0204 /* connect or disconnect action on system component */
#define RTDS_ERROR_ALL_COMP                                    0x0205 /* all component can only be used in the MTC */

/* ERROR RELATED TO ASN.1 ENCODING/DECODING */
#define RTDS_ERROR_ASN1_ENCODING_FAILED                        0x0300 /* ASN.1 encoding failed */
#define RTDS_ERROR_ASN1_DECODING_FAILED                        0x0300 /* ASN.1 decoding failed */
