/*****************************************
 *    System defines: OK/ERROR/NONE     *
 *****************************************/
#define RTDS_ERROR   -1
#define RTDS_OK       0
#define RTDS_TIMEOUT  2     /* timeout return value (ususally for semaphores */
#define RTDS_NONE     0     /* Default option parameter */

/*
 * TYPE RTDS_SEMAPHORE.ID:
 * ----------------------
 * Type for a semaphore identifier
 * We need the declaration for the class RTDS_SemaphoreProcess so it's forward-declared.
 * Care should be taken to include the 'real' declaration afterwards everytime this file
 * is included.
 */
class RTDS_SemaphoreProcess;
typedef RTDS_SemaphoreProcess * RTDS_SemaphoreId;

/*
 * TYPE RTDS_SEMAPHORE_STATUS:
 * ----------------------
 * Type for a semaphore status
 */
typedef int RTDS_SemaphoreStatus;

/*************************************************
 *        Posix RTDS_SemTimeoutType
 * -----------------------------------------------
 * Type for time to wait for semaphore
 *                (time in ms)
 *************************************************/
typedef long RTDS_SemTimeoutType;

/*
 * TYPE RTDS_SEMAPHORE_TIMEOUT:
 * ----------------------
 * Type for a semaphore timeout value
 */
typedef RTDS_SemTimeoutType RTDS_SemaphoreTimeout;


/*
 * STRUCT RTDS_GLOBAL.SEMAPHORE.INFO:
 * -------------------------------
 * Type for the list of semaphores in the system with their information
 */
typedef struct RTDS_GlobalSemaphoreInfo
    {
    RTDS_SemaphoreId                semaphoreId;     /* The semaphore address  */
    int                             semaphoreNumber; /* Semaphore number representing its name */
    struct RTDS_GlobalSemaphoreInfo *next;           /* Next semaphoreInfo */
    } RTDS_GlobalSemaphoreInfo;


/*
 * TYPE RTDS_PROCESS.PRIORITY.
 * ----------------------
 * Type for process priority
 */
typedef int RTDS_ProcessPriority;


/*
 * STRUCT RTDS_QCB : Queue Control Block
 * -------------------------------------
 * Structure that contains :
 *     - pointer on chain list Semaphore (that protect chained list)
 *     - pointer on the first message
 *     - pointer on Blocking Semaphore (That will allows to wait for a message)
 *
 */
typedef struct RTDS_QCB
  {
  struct  RTDS_MessageHeader  * queue;            /* Pointer on the first message in the queue*/
  } RTDS_QCB;


/*
 * TYPE RTDS_OS_QueueId:
 * ---------------------
 * Type for a message queue identifier
 */
typedef RTDS_QCB * RTDS_RtosQueueId;


/*
 * TYPE RTDS_RtosTaskId:
 * ---------------------
 * Type for a task identifier in the underlying RTOS: unused...
 */
typedef short RTDS_RtosTaskId;


/*
 * STRUCT RTDS_TIMER.STATE:
 * ------------------------
 * Element in chained list for all active timers
 */
typedef struct RTDS_TimerState
  {
  long                        timerNumber;    /* Message number for the timer name */
  long                        timerUniqueId;  /* Timer's unique identifier among all timers */
  unsigned long               timeoutValue;   /* System tick counter value when it will go off */
  unsigned long               timeoutDelay;   /* Delay before goes off; RELATIVE TO PREVIOUS TIMER! */
  struct RTDS_SdlInstanceId * receiverId;     /* Instance identifier for the receiver */
  int                         state;          /* State for the timer (RTDS_TIMER_OK or RTDS_TIMER_CANCELLED) */
  struct RTDS_TimerState    * next;           /* Next timer in list */
  } RTDS_TimerState;


/*
 * Additional fields in common types
 * ---------------------------------
 */
/* Message header: none */
#define RTDS_MESSAGE_HEADER_ADDITIONNAL_FIELDS
/* Process information: add priority */
#define RTDS_GLOBAL_PROCESS_INFO_ADDITIONNAL_FIELDS \
  RTDS_ProcessPriority priority;
