/* PragmaDev RTDS win32 integration */

/* Include unistd when using a unix based system or cygwin */
#ifdef __CYGWIN__
#include <unistd.h>
#else
#include <stdlib.h>
#endif

#include "RTDS_Error.h"
#include "RTDS_MACRO.h"
#include "RTDS_InternalConstants.h"

#if defined(RTDS_FORMAT_TRACE)
#include "RTDS_FormatTrace.h"
#endif

#include "RTDS_BinarySemaphoreProcess.h"

#include "RTDS_InstanceManager.h"

/*
** CONSTRUCTOR:
** ------------
*/

RTDS_BinarySemaphoreProcess::RTDS_BinarySemaphoreProcess(RTDS_Scheduler * parentScheduler) : RTDS_SemaphoreProcess(parentScheduler)
  {
  };


/*
** METHOD RTDS_continuousSignals:
** ------------------------------
** Executes a transition for a continuous signal in process or procedure
*/

short RTDS_BinarySemaphoreProcess::RTDS_continuousSignals(int * lowestPriority)
  {
  return 0;
  }


/*
** METHOD RTDS_executeTransition:
** ------------------------------
** Entry point for all transitions in process or procedure
*/

short RTDS_BinarySemaphoreProcess::RTDS_executeTransition(RTDS_MessageHeader * currentMessage)
  {
  RTDS_SdlInstanceId  * waiter_id;
  
  // Remember previous state
  RTDS_sdlStatePrev = RTDS_currentContext->sdlState;
  // Remember message as current one
  RTDS_currentContext->currentMessage = currentMessage;
  // Standard double-switch for all other messages
  if ( currentMessage != NULL )
    {
    RTDS_senderId = RTDS_currentContext->currentMessage->sender;
    switch(RTDS_currentContext->currentMessage->messageNumber)
      {
      /* -- Take attempt */
      case RTDS_message_RTDS_takeSemaphore:
        /* If semaphore is available */
        if ( this->is_available )
          {
          /* Make it unavailable */
          this->is_available = 0;
          /* Take succeeded */
          this->RTDS_msgQueueSendToId(RTDS_message_RTDS_takeSucceeded, 0, NULL, SENDER);
          }
        /* If semaphore is not available */
        else
          {
          /* Add message sender to list of waiting processes */
          this->_addWaitingInstance(SENDER);
          }
        break;
      
      /* -- Give */
      case RTDS_message_RTDS_giveSemaphore:
        /* If semaphore wasn't already available */
        if ( ! this->is_available )
          {
          /* If there are waiting processes, pop first one from the list */
          if ( this->_popFirstWaitingInstance(&waiter_id) )
            {
            /* If found, send message indicating take succeeded for it */
            this->RTDS_msgQueueSendToId(RTDS_message_RTDS_takeSucceeded, 0, NULL, waiter_id);
            }
          /* If no waiting instances */
          else
            {
            /* Make emaphore available */
            this->is_available = 1;
            }
          }
        break;
        
      /* -- Take cancel */
      case RTDS_message_RTDS_cancelTake:
        /* Remove message sender from list of instances waiting for semaphore */
        if ( ! this->_removeWaitingInstance(SENDER) )
          {
          /* Since we're scheduled, instance should *ALWAYS* be found; if it isn't, it's an error */
          RTDS_SYSTEM_ERROR(RTDS_ERROR_SEM_CANCEL_TAKE);
          }
        break;
      }
    }
  return 0;
  }
