/* PragmaDev RTDS win32 integration */

/* Include unistd when using a unix based system or cygwin */
#ifdef __CYGWIN__
#include <unistd.h>
#else
#include <stdlib.h>
#endif

#include "RTDS_Error.h"
#include "RTDS_MACRO.h"
#include "RTDS_InternalConstants.h"

#if defined(RTDS_FORMAT_TRACE)
#include "RTDS_FormatTrace.h"
#endif

#include "RTDS_MutexSemaphoreProcess.h"

#include "RTDS_InstanceManager.h"

/*
** CONSTRUCTOR:
** ------------
*/

RTDS_MutexSemaphoreProcess::RTDS_MutexSemaphoreProcess(RTDS_Scheduler * parentScheduler) : RTDS_SemaphoreProcess(parentScheduler)
  {
    this->taker_instance_id = NULL;
    this->take_count = 0;
  };


/*
** METHOD RTDS_continuousSignals:
** ------------------------------
** Executes a transition for a continuous signal in process or procedure
*/

short RTDS_MutexSemaphoreProcess::RTDS_continuousSignals(int * lowestPriority)
  {
  return 0;
  }


/*
** METHOD RTDS_executeTransition:
** ------------------------------
** Entry point for all transitions in process or procedure
*/

short RTDS_MutexSemaphoreProcess::RTDS_executeTransition(RTDS_MessageHeader * currentMessage)
  {
  RTDS_SdlInstanceId  * waiter_id;
  
  // Remember previous state
  RTDS_sdlStatePrev = RTDS_currentContext->sdlState;
  // Remember message as current one
  RTDS_currentContext->currentMessage = currentMessage;
  // Standard double-switch for all other messages
  if ( currentMessage != NULL )
    {
    RTDS_senderId = RTDS_currentContext->currentMessage->sender;
    switch(RTDS_currentContext->currentMessage->messageNumber)
      {
      /* -- Take attempt */
      case RTDS_message_RTDS_takeSemaphore:
        /* If semaphore is available or already taken by same instance */
        if ( ( this->taker_instance_id == NULL ) || ( this->taker_instance_id == RTDS_senderId ) )
          {
          /* Set taker and increase take count */
          this->taker_instance_id = RTDS_senderId;
          this->take_count += 1;
          /* Take succeeded */
          this->RTDS_msgQueueSendToId(RTDS_message_RTDS_takeSucceeded, 0, NULL, RTDS_senderId);
          }
        /* If semaphore is not available or taken by another instance */
        else
          {
          /* Add message sender to list of waiting processes */
          this->_addWaitingInstance(RTDS_senderId);
          }
        break;
      
      /* -- Give */
      case RTDS_message_RTDS_giveSemaphore:
        /* ??? Should we check that the giver instance is actually the taker? ??? */
        if ( this->taker_instance_id == RTDS_senderId )
          {
          /* Decrease take count */
          this->take_count -= 1;
          /* If it reaches 0, semaphore is free */
          if ( this->take_count <= 0 )
            {
            this->taker_instance_id = NULL;
            /* If there are waiting instances, pop first one from the list */
            if ( this->_popFirstWaitingInstance(&waiter_id) )
              {
              /* Send message indicating take succeeded for it */
              this->RTDS_msgQueueSendToId(RTDS_message_RTDS_takeSucceeded, 0, NULL, waiter_id);
              /* Remember it as the taker */
              this->taker_instance_id = waiter_id;
              this->take_count = 1;
              }
            }
          }
        break;
        
      /* -- Take cancel */
      case RTDS_message_RTDS_cancelTake:
        /* Remove message sender from list of instances waiting for semaphore */
        if ( ! this->_removeWaitingInstance(RTDS_senderId) )
          {
          /* Since we're scheduled, instance should *ALWAYS* be found; if it isn't, it's an error */
          RTDS_SYSTEM_ERROR(RTDS_ERROR_SEM_CANCEL_TAKE);
          }
        break;
      }
    }
  return 0;
  }
