/* Include unistd when using a unix based system or cygwin */
#ifdef __CYGWIN__
#include <unistd.h>
#else
#include <stdlib.h>
#endif

#include "RTDS_SemaphoreProcess.h"


/*
** CONSTRUCTOR:
** ------------
*/

RTDS_SemaphoreProcess::RTDS_SemaphoreProcess(RTDS_Scheduler * parentScheduler) : RTDS_Proc(parentScheduler)
  {
  this->waiting_processes_head = NULL;
  this->waiting_processes_last = NULL;
  };


/*
** METHOD _addWaitingInstance:
** ---------------------------
** Adds an instance to the list of those waiting for the semaphore
*/

void RTDS_SemaphoreProcess::_addWaitingInstance(RTDS_SdlInstanceId * instance_id)
  {
  if ( this->waiting_processes_last == NULL )
    {
    this->waiting_processes_head = new RTDS_WaitingProcessList;
    this->waiting_processes_last = this->waiting_processes_head;
    }
  else
    {
    this->waiting_processes_last->next = new RTDS_WaitingProcessList;
    this->waiting_processes_last = this->waiting_processes_last->next;
    }
  this->waiting_processes_last->sdlInstanceId = instance_id;
  this->waiting_processes_last->next = NULL;
  }


/*
** METHOD _popFirstWaitingInstance:
** --------------------------------
** Pops the first waiting instance id in the list and returns it in returned_id.
** Returns 1 if there are waiting instances, and 0 if there aren't
*/

short RTDS_SemaphoreProcess::_popFirstWaitingInstance(RTDS_SdlInstanceId ** returned_id)
  {
  RTDS_WaitingProcessList * waiting_process_current;
  
  if ( this->waiting_processes_head == NULL )
    return 0;
  *returned_id = this->waiting_processes_head->sdlInstanceId;
  waiting_process_current = this->waiting_processes_head;
  this->waiting_processes_head = this->waiting_processes_head->next;
  if ( this->waiting_processes_head == NULL )
    this->waiting_processes_last = NULL;
  delete waiting_process_current;
  return 1;
  }


/*
** METHOD _deleteWaitingInstance:
** ------------------------------
** Removes an instance to the list of those waiting for the semaphore. Returns 1
** if the instance was found in the waiting ones, 0 if it wasn't.
*/

short RTDS_SemaphoreProcess::_removeWaitingInstance(RTDS_SdlInstanceId * instance_id)
  {
  RTDS_WaitingProcessList * waiting_process_previous = NULL;
  RTDS_WaitingProcessList * waiting_process_current;
  
  /* Browse list of waiting instances */
  for ( waiting_process_current = this->waiting_processes_head;
        waiting_process_current != NULL;
        waiting_process_current = waiting_process_current->next )
    {
    /* If given instance found, remove it from the list */
    if ( waiting_process_current->sdlInstanceId == instance_id )
      {
      if ( waiting_process_previous == NULL )
        this->waiting_processes_head = this->waiting_processes_head->next;
      else
        waiting_process_previous->next = waiting_process_current->next;
      if ( waiting_process_current == this->waiting_processes_last )
        this->waiting_processes_last = waiting_process_previous;
      delete waiting_process_current;
      return 1;
      }
    }
  // If we get there, instance not found
  return 0;
  }

