/* PragmaDev RTDS win32 integration */

/* Include unistd when using a unix based system or cygwin */
#ifdef __CYGWIN__
#include <unistd.h>
#else
#include <stdlib.h>
#include <string.h>
#endif

#include "RTDS_MACRO.h"

#include "RTDS_SemaphoreTakeProcedure.h"

/*
** CONSTRUCTOR:
** ------------
*/

RTDS_SemaphoreTakeProcedure::RTDS_SemaphoreTakeProcedure(RTDS_Scheduler * parentScheduler, RTDS_SdlInstanceId * _semaphore_id, long _time_out) : RTDS_Proc(parentScheduler)
  {
  this->RTDS_isProcedure = 1;
  this->semaphore_id = _semaphore_id;
  this->time_out = _time_out;
  }


/*
** METHOD RTDS_continuousSignals:
** ------------------------------
** Executes a transition for a continuous signal in process or procedure
*/

short RTDS_SemaphoreTakeProcedure::RTDS_continuousSignals(int * lowestPriority)
  {
  return 0;
  }


/*
** METHOD RTDS_executeTransition:
** ------------------------------
** Entry point for all transitions in process or procedure
*/

short RTDS_SemaphoreTakeProcedure::RTDS_executeTransition(RTDS_MessageHeader * currentMessage)
  {
  short has_returned = 0;
  
  // Remember previous state
  RTDS_sdlStatePrev = this->RTDS_currentContext->sdlState;
  // Remember message as current one
  this->RTDS_currentContext->currentMessage = currentMessage;
  // -- Initial transition --
  if ( this->RTDS_currentContext->currentMessage == NULL )
    {
    if ( this->time_out != RTDS_SEMAPHORE_TIME_OUT_FOREVER )
      this->RTDS_setTimer(RTDS_message_RTDS_takeTimeOut, time_out);
    this->RTDS_msgQueueSendToId(RTDS_message_RTDS_takeSemaphore, 0, NULL, semaphore_id);
    // Set dummy state to force state change when the procedure returns
    this->RTDS_currentContext->sdlState = -1;
    }
  // Switch for all other messages
  else
    {
    if ( this->RTDS_currentContext->currentMessage->timerUniqueId != 0 )
      {
      RTDS_TIMER_CLEAN_UP(this->RTDS_currentContext);
      if ( this->RTDS_currentContext->currentMessage == NULL )
        return 0;
      }
    RTDS_senderId = this->RTDS_currentContext->currentMessage->sender;
    switch(this->RTDS_currentContext->currentMessage->messageNumber)
      {
      // -- Timer time-out: take failed --
      case RTDS_message_RTDS_takeTimeOut:
        this->RTDS_msgQueueSendToId(RTDS_message_RTDS_cancelTake, 0, NULL, semaphore_id);
        this->RTDS_return_value = RTDS_ERROR;
        has_returned = 1;
        break;
      // -- Take succeeded --
      case RTDS_message_RTDS_takeSucceeded:
        this->RTDS_resetTimer(RTDS_message_RTDS_takeTimeOut);
        this->RTDS_return_value = RTDS_OK;
        has_returned = 1;
        break;
      // -- Everything else is saved
      default:
        RTDS_MSG_SAVE(this->RTDS_currentContext->currentMessage);
        return 0;
      }
    }
  RTDS_FREE(currentMessage);
  this->RTDS_currentContext->currentMessage = NULL;
  return has_returned;
  }

