#ifdef __cplusplus
extern "C" {
#endif

#ifndef _RTDS_DYNAMIC_TRACE_H_
#define _RTDS_DYNAMIC_TRACE_H_

#ifdef RTDS_FORMAT_TRACE

#include "RTDS_OS.h"
#include "RTDS_MACRO.h"

/*
 * RTDS_FormatTrace.h: Add Type: 
 *			- RTDS_CmdTraceConfig,
 *			- RTDS_DynamicConfType,
 */
enum RTDS_DynamicConfType {TRACING, ALL_SDLEVENT, SDL_MSG, SDL_MSG_DATA, SDL_TIMER, SDL_PROCESS, SDL_SEMAPHORE, SDL_STATE, SDL_CLOCK};

typedef struct RTDS_CmdTraceConfig
	{
	enum RTDS_DynamicConfType configId;
	int status;
	} RTDS_CmdTraceConfig;


#define RTDS_TCP_EVENT_MESSAGE_WITHDATA 1
#define RTDS_TCP_EVENT_MESSAGE_WITHOUTDATA 0

#define RTDS_DTRACE_PAUSE()  RTDS_globalEventTraceEnable=0;
#define RTDS_DTRACE_RESUME() RTDS_globalEventTraceEnable=1; 
#define RTDS_DTRACE_MESSAGEDATA_INFO(STATE) RTDS_globalEventMessageDataEnable=STATE; 
#define RTDS_DTRACE_CLOCK_INFORMATION(STATE) RTDS_globalEventTimeEnable=STATE; 
#define RTDS_DTRACE_MESSAGE(STATE) RTDS_globalEventMessageEnable=STATE; 
#define RTDS_DTRACE_TIMER(STATE) RTDS_globalEventTimerEnable=STATE; 
#define RTDS_DTRACE_SDLSTATE(STATE) RTDS_globalEventSdlStateEnable=STATE; 
#define RTDS_DTRACE_PROCESS(STATE) RTDS_globalEventProcessEnable=STATE; 
#define RTDS_DTRACE_SEMAPHORE(STATE) RTDS_globalEventSemaphoreEnable=STATE;

/* Regular trace size for the memory allocation */
#define RTDS_REGULAR_PARAMSIZE 64

extern int RTDS_FormatTrace(	unsigned long time, RTDS_GlobalTraceInfo traceEntry, int waitAckMode, char **formatedTrace);
extern void RTDS_ConfigureTrace(RTDS_CmdTraceConfig * configStruc);



#endif /* RTDS_FORMAT_TRACE */
#endif /* _RTDS_DYNAMIC_TRACE_H_ */

#ifdef __cplusplus
}
#endif
