#ifndef _RTDS_BASICTYPES_H_
#define _RTDS_BASICTYPES_H_

#include "stdlib.h"
#include "uit_type.h"

#ifdef __cplusplus
extern "C" {
#endif

/*MEMORY POOL FOR DYNAMIC ALLOCATION */
#define RTDS_MEMPOOL_ID             1        /* Memory pool ID : used for the memory allocation */
#define RTDS_MEMPOOL_SIZE           50000    /* Memory pool size in octet */
#define RTDS_MEMORY_POOL_CREATION RTDS_MPoolCreate(RTDS_MEMPOOL_SIZE);

/* ERROR MESSAGE */
#define RTDS_SYS_NONE                              0 /* Default option parameter */

#define UITRON_SEMAPHORE_LOCKED                    0 /* Locked parameter for semaphore creation */
#define UITRON_SEMAPHORE_INTERPROCESS              1 /* Creation parameter for using this sem. in various process */
#define UITRON_SEMAPHORE_MONOPROCESS               0 /* Creation parameter for using this sem. only in the creating process */

#define  RTDS_UITRON_SEM_TIMEOUT_FOREVER           -1
#define  UITRON_SEMAPHORE_DEFAULT_MODE             TA_TFIFO /* Default mode for creating semaphore */

/******************************************************************
 *    RTOS Specific
 *
 *    When using ecos with uITRON package:
 ******************************************************************/
#define RTDS_MAX_TASK                CYGNUM_UITRON_TASKS - CYGNUM_UITRON_TASKS_INITIALLY
#define RTDS_MAX_SEMAPHORE           CYGNUM_UITRON_SEMAS - CYGNUM_UITRON_SEMAS_INITIALLY
#define RTDS_MAX_MSGBOX              CYGNUM_UITRON_MBOXES - CYGNUM_UITRON_MBOXES_INITIALLY
#define RTDS_MAX_TIMER               CYGNUM_UITRON_ALARMS - 1

#define RTDS_INITIAL_NB_MSGBOX       CYGNUM_UITRON_MBOXES_INITIALLY
#define RTDS_INITIAL_NB_SEMAPHORE    CYGNUM_UITRON_SEMAS_INITIALLY
#define RTDS_INITIAL_NB_TASK         CYGNUM_UITRON_TASKS_INITIALLY
#define RTDS_INITIAL_NB_TIMER        1
/******************************************************************
 *    Used for ressource Id allocation and desallocation
 *     In function :
 *                 RTDS_GetResourceId
 *                 RTDS_ReleaseResourceId
 ******************************************************************/
#define RTDS_TASK_RESS       0
#define RTDS_SEM_RESS        1
#define RTDS_MSGB_RESS       2
#define RTDS_TIMER_RESS      3

/*****************************************
 *    System defines: OK/ERROR/NONE     *
 *****************************************/
#define RTDS_ERROR                 -1
#define RTDS_OK                    0
#define NONE                       RTDS_SYS_NONE    /* default option: not used parameter */

/*********************************************
 *    Define for RTDS_OS and RDTS_MACRO     *
 *********************************************/
#define RTDS_SEMAPHORE_MAX_NAME_LENGTH      20 /* Maximum length of a semaphore name */
#define RTDS_TASK_OPTIONS                   NONE /* taskSpawn options */
#define RTDS_TASK_STACK_SIZE                CYGNUM_UITRON_STACK_SIZE/* Stack size when creating a new task */

/********************************************************
 * Define for SDL Symbols (generated by RTDS generator) *
 ********************************************************/
#define RTDS_SEMAPHORE_TIME_OUT_FOREVER     RTDS_UITRON_SEM_TIMEOUT_FOREVER     /* Time out option when taking the semaphore : wait forever */
#define RTDS_SEMAPHORE_TIME_OUT_NO_WAIT     0                                   /* Time out option when taking the semaphore : no wait */
#define RTDS_SEMAPHORE_OPTION_PRIO          NONE                                /* Semaphore creation option: queuing based on priority */
#define RTDS_SEMAPHORE_OPTION_FIFO          NONE                                /* Semaphore creation option: queuing based on FIFO */
#define RTDS_BINARY_SEM_INITIAL_EMPTY       0                                   /* Binary semaphore creation initial state: empty */
#define RTDS_BINARY_SEM_INITIAL_FULL        1                                   /* Binary semaphore creation initial state: full */
#define RTDS_MUTEX_SEM_DELETE_SAFE          NONE                                /* Protects a task that owns the semaphore from unexpected deletion */
#define RTDS_MUTEX_SEM_INVERSION_SAFE       NONE                                /* Protect the system from priority inversion */

/*********************************************************************
 * Possible values for UITRON/Pthead thread priority depend  *
 * of the OS (Linux => 0<pri<99  and Solaris => 0<prio<59)     *
 * higher value correspond to higher priority              *
 *********************************************************************/
#define RTDS_DEFAULT_PROCESS_PRIORITY        4


/*
 * Additional fields in common types
 * ---------------------------------
 */
/* Message header: none */
#define RTDS_MESSAGE_HEADER_ADDITIONNAL_FIELDS

/* Process information: add priority */
#define RTDS_GLOBAL_PROCESS_INFO_ADDITIONNAL_FIELDS \
    RTDS_ProcessPriority priority; T_CMBX * taskQueue; T_CTSK * taskStruct; int taskstt;




enum RTDS_TypeName {COUNTING, BINARY, MUTEX};

typedef struct rtds_SemId
    {
    ID semId;
    enum    RTDS_TypeName semType;
    T_CSEM  confStruct;
    } rtds_SemId;

typedef union RTDS_SemType
    {
    ID      SemID;
    struct  rtds_SemId RTDS_Info;
    } RTDS_SemType;

typedef RTDS_SemType *RTDS_SemId;

typedef void * FUNCPTR;



/******************************************************************
 *        SEMAPHORE TYPES
 * ----------------------------------------------------------------
 *    Use of a UNION to detect set semaphore type according
 *    the SDL-RT specification
 *
 *******************************************************************/


/*
 * TYPE RTDS_PROCESS.ID:
 * ----------------------
 * Type for process identifier
 */
typedef ID RTDS_RtosTaskId;


/*
 * TYPE RTDS_PROCESS.PRIORITY.
 * ----------------------
 * Type for process priority
 */
typedef int RTDS_ProcessPriority;

/*
 * TYPE RTDS_QUEUE.Id:
 * ----------------------
 * Type for a message queue identifier
 */
typedef ID RTDS_RtosQueueId;

/*
 * TYPE RTDS_SEMAPHORE.ID:
 * ----------------------
 * Type for a semaphore identifier
 */
typedef RTDS_SemId RTDS_SemaphoreId;

/*
 * DEFINE FOR TIMER:
 * ------------------------------
 */
typedef HNO RTDS_TimerId;

/*
 * TYPE RTDS_SEMAPHORE_STATUS:
 * ----------------------
 * Type for a semaphore status
 */
typedef int RTDS_SemaphoreStatus;

/*************************************************
 *             RTDS_SemTimeoutType
 * -----------------------------------------------
 * Type for time to wait for semaphore
 *                (time in ms)
 *************************************************/
typedef long RTDS_SemTimeoutType;

/*
 * TYPE RTDS_SEMAPHORE_TIMEOUT:
 * ----------------------
 * Type for a semaphore timeout value
 */
typedef RTDS_SemTimeoutType RTDS_SemaphoreTimeout;




/*
 * STRUCT RTDS_TIMER.STATE:
 * ------------------------
 * Element in chained list for all active timers
 */

typedef struct RTDS_TimerState
    {
    long                   timerNumber;     /* Message number for the timer name */
    long                   timerUniqueId;   /* Timer's unique identifier among all timers */
    unsigned long          timeoutValue;    /* System tick counter value when it will go off */
    struct RTDS_SdlInstanceId * receiverId; /* The instance id of the receiver */
    int                    state;           /* State for the timer (RTDS_TIMER_OK or RTDS_TIMER_CANCELLED) */
    RTDS_TimerId           watchDogId;      /* Id of the watchDog */
    T_DALM                 *alarmControl;    /* The structure which define the alarm */
    struct RTDS_TimerState *next;           /* 0x18 Next timer in list */
    } RTDS_TimerState;

 
 
 #endif /* _RTDS_BASICTYPES_H_ */
 
