/*******************************************************************
 *                  PragmaDev RTDS win32 integration
 *******************************************************************
 *                                         RTDS_TCP_CLIENT.H
 *-------------------------------------------------------------------
 * These function are used to send messages from
 * the RTDS Debugger window!
 *
 *                    + RTDS_commandInterpreterStart
 *                    + RTDS_MsgSenderTCPClient
 *                    + RTDS_commandInterpreterStop
 *                    + RTDS_read_Socket
 *                    + RTDS_convert_Data
 *
 ******************************************************************* */

#ifdef __cplusplus
extern "C" {
#endif

#ifndef _RTDS_TCP_CLIENT_H_
#define _RTDS_TCP_CLIENT_H_

#if RTDS_SOCKET_PORT
 #ifndef RTDS_SOCKET_IP_ADDRESS
    #define RTDS_SOCKET_IP_ADDRESS "127.0.0.1"
 #endif


#define TO_STRING(X) #X
#define GET_HOSTNAME_STRING(X) TO_STRING(X)


#define RTDS_SOCKET_ID_TYPE int
extern RTDS_SOCKET_ID_TYPE RTDS_InitSocket( char * hostNameString, int portNum );
extern int RTDS_CloseSocket( RTDS_SOCKET_ID_TYPE socketDescriptor );
extern int RTDS_ReadSocket( RTDS_SOCKET_ID_TYPE socketDescriptor, char ** data, int * dataSize, char delimiterChar, char escapeChar );
extern int RTDS_SendSocket( RTDS_SOCKET_ID_TYPE socketId, char * commandString, int size );

#endif /* RTDS_SOCKET_PORT */

#endif /* _RTDS_TCP_CLIENT_H_ */

#ifdef __cplusplus
}
#endif

