import sys
import services.xml.cxml as cxml
from services.xml.string import normalize

last_source = None
translations = {}

def _get_source(element_name, element_text):
    global last_source
    assert last_source is None
    last_source = element_text.strip()

def _get_target(element_name, element_text):
    global last_source
    translations.setdefault(last_source, set()).add(element_text.strip())
    last_source = None

element_mapping = {'source': (None, _get_source, None), 'target': (None, _get_target, None)}
cxml.parse("dictionary", element_mapping, sys.argv[1], cxml.PARSE_STRICT)

def key(s):
    k = s.lower()
    while k and not k[0].isalnum():
        k = k[1:]
    return ''.join(k.split())

print '<?xml version="1.0" encoding="UTF-8"?>'
print
print '<!DOCTYPE Diagram SYSTEM "dictionary.dtd">'
print
print '<dictionary>'
decorated_keys = [(key(src), src) for src in translations]
for dummy, source in sorted(decorated_keys):
    targets = translations[source]
    if len(targets) != 1:
        sys.stderr.write('Duplicate translation for %r!: %s\n' % (source, ', '.join(repr(t) for t in targets)))
    print '<translation><source>%s</source><target>%s</target></translation>' % (normalize(source), normalize(targets.pop()))
print '</dictionary>'
